//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef RawResource_CffReader_H
#define RawResource_CffReader_H

#include "BinaryItemCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for RawResource
    static const Int32 CFF_RAW_RESOURCE_RAW_DATA_LENGTH_OFFSET                                = (CFF_BINARY_ITEM_SIZE);
    static const Int32 CFF_RAW_RESOURCE_RAW_DATA_PTR_OFFSET                                   = (4 + CFF_RAW_RESOURCE_RAW_DATA_LENGTH_OFFSET);
    static const Int32 CFF_RAW_RESOURCE_SIZE                                                  = (CFF_PTR_SIZE + CFF_RAW_RESOURCE_RAW_DATA_PTR_OFFSET);

    // getter methods for RawResource
    inline Int32 GetRawResourceRawDataLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RAW_RESOURCE_RAW_DATA_LENGTH_OFFSET);
    }
    inline Int32 GetRawResourceRawDataRegion(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RAW_RESOURCE_RAW_DATA_PTR_OFFSET);
    }

}}} //namespaces

#endif //RawResource_CffReader_H
