//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Node_CffReader_H
#define Node_CffReader_H

#include "SceneNodeBaseCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Node
    static const Int32 CFF_NODE_LAYOUT_PROPERTIES_PTR_OFFSET                                  = (CFF_SCENE_NODE_BASE_SIZE);
    static const Int32 CFF_NODE_SCRIPT_COMPONENT_COLLECTION_PTR_OFFSET                        = (CFF_PTR_SIZE + CFF_NODE_LAYOUT_PROPERTIES_PTR_OFFSET);
    static const Int32 CFF_NODE_SIZE                                                          = (CFF_PTR_SIZE + CFF_NODE_SCRIPT_COMPONENT_COLLECTION_PTR_OFFSET);

    // getter methods for Node
    inline Int32 GetNodeLayoutPropertiesCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_NODE_LAYOUT_PROPERTIES_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle),  offset); 
    }
    inline AssetDataHandle GetNodeLayoutPropertiesElementAt(const AssetDataHandle& handle, Int32 elementSize, Int32 index)
    {
        Int32 listOffset =  CffGetValSafe<Int32>(handle, CFF_NODE_LAYOUT_PROPERTIES_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(listHandle, CFF_INT_SIZE + (index * elementSize));
    }
    inline AssetDataHandle GetNodeScriptComponentCollection(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_NODE_SCRIPT_COMPONENT_COLLECTION_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //Node_CffReader_H
