//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Node3D_CffReader_H
#define Node3D_CffReader_H

#include "NodeCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Node3D
    static const Int32 CFF_NODE_3D_TRANSFORM_PTR_OFFSET                                       = (CFF_NODE_SIZE);
    static const Int32 CFF_NODE_3D_POSITION_OFFSET                                            = (CFF_PTR_SIZE + CFF_NODE_3D_TRANSFORM_PTR_OFFSET);
    static const Int32 CFF_NODE_3D_PIVOT_POINT_OFFSET                                         = (12 + CFF_NODE_3D_POSITION_OFFSET);
    static const Int32 CFF_NODE_3D_ROTATION_OFFSET                                            = (12 + CFF_NODE_3D_PIVOT_POINT_OFFSET);
    static const Int32 CFF_NODE_3D_SCALE_OFFSET                                               = (12 + CFF_NODE_3D_ROTATION_OFFSET);
    static const Int32 CFF_NODE_3D_CENTER_OFFSET                                              = (12 + CFF_NODE_3D_SCALE_OFFSET);
    static const Int32 CFF_NODE_3D_RADIUS_OFFSET                                              = (12 + CFF_NODE_3D_CENTER_OFFSET);
    static const Int32 CFF_NODE_3D_BOX_LOWER_LEFT_BACK_VERTEX_OFFSET                          = (4 + CFF_NODE_3D_RADIUS_OFFSET);
    static const Int32 CFF_NODE_3D_BOX_UPPER_RIGHT_FRONT_VERTEX_OFFSET                        = (12 + CFF_NODE_3D_BOX_LOWER_LEFT_BACK_VERTEX_OFFSET);
    static const Int32 CFF_NODE_3D_IS_INTERSECTION_TEST_ENABLED_OFFSET                        = (12 + CFF_NODE_3D_BOX_UPPER_RIGHT_FRONT_VERTEX_OFFSET);
    static const Int32 CFF_NODE_3D_IS_RENDERING_ENABLED_OFFSET                                = (4 + CFF_NODE_3D_IS_INTERSECTION_TEST_ENABLED_OFFSET);
    static const Int32 CFF_NODE_3D_SCOPE_BITS_OFFSET                                          = (4 + CFF_NODE_3D_IS_RENDERING_ENABLED_OFFSET);
    static const Int32 CFF_NODE_3D_RENDER_ORDER_BIN_OFFSET                                    = (4 + CFF_NODE_3D_SCOPE_BITS_OFFSET);
    static const Int32 CFF_NODE_3D_RENDER_ORDER_RANK_OFFSET                                   = (16 + CFF_NODE_3D_RENDER_ORDER_BIN_OFFSET);
    static const Int32 CFF_NODE_3D_RENDER_BENCHMARK_OFFSET                                    = (4 + CFF_NODE_3D_RENDER_ORDER_RANK_OFFSET);
    static const Int32 CFF_NODE_3D_ALPHA_VALUE_OFFSET                                         = (4 + CFF_NODE_3D_RENDER_BENCHMARK_OFFSET);
    static const Int32 CFF_NODE_3D_RESOLVED_APPEARANCE_COLLECTION_ATTACHMENT_TYPE_OFFSET      = (4 + CFF_NODE_3D_ALPHA_VALUE_OFFSET);
    static const Int32 CFF_NODE_3D_RESOLVED_APPEARANCE_COLLECTION_ATTACHMENT_PTR_OFFSET       = (4 + CFF_NODE_3D_RESOLVED_APPEARANCE_COLLECTION_ATTACHMENT_TYPE_OFFSET);
    static const Int32 CFF_NODE_3D_CHILDREN_PTR_OFFSET                                        = (CFF_PTR_SIZE + CFF_NODE_3D_RESOLVED_APPEARANCE_COLLECTION_ATTACHMENT_PTR_OFFSET);
    static const Int32 CFF_NODE_3D_SIZE                                                       = (CFF_PTR_SIZE + CFF_NODE_3D_CHILDREN_PTR_OFFSET);

    // getter methods for Node3D
    inline bool GetOptionalNode3DTransform(const AssetDataHandle& handle, const Float*& matrixVector)
    {
        Int32 offsetToValue = CffGetValSafe<Int32>(handle, CFF_NODE_3D_TRANSFORM_PTR_OFFSET);
        if (offsetToValue == -1) {
            return false;
        }
        AssetDataHandle valueHandle = CffGetHandle(CffGetAssetLibHandle(handle), offsetToValue);
        matrixVector = CffGetPtrSafe<Float>(valueHandle, 0);
        return true;
    }
    inline void GetNode3DPosition(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_NODE_3D_POSITION_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_NODE_3D_POSITION_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_NODE_3D_POSITION_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline void GetNode3DPivotPoint(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_NODE_3D_PIVOT_POINT_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_NODE_3D_PIVOT_POINT_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_NODE_3D_PIVOT_POINT_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline void GetNode3DRotation(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_NODE_3D_ROTATION_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_NODE_3D_ROTATION_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_NODE_3D_ROTATION_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline void GetNode3DScale(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_NODE_3D_SCALE_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_NODE_3D_SCALE_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_NODE_3D_SCALE_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline void GetNode3DCenter(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_NODE_3D_CENTER_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_NODE_3D_CENTER_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_NODE_3D_CENTER_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline Float GetNode3DRadius(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_NODE_3D_RADIUS_OFFSET);
    }
    inline void GetNode3DBoxLowerLeftBackVertex(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_NODE_3D_BOX_LOWER_LEFT_BACK_VERTEX_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_NODE_3D_BOX_LOWER_LEFT_BACK_VERTEX_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_NODE_3D_BOX_LOWER_LEFT_BACK_VERTEX_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline void GetNode3DBoxUpperRightFrontVertex(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_NODE_3D_BOX_UPPER_RIGHT_FRONT_VERTEX_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_NODE_3D_BOX_UPPER_RIGHT_FRONT_VERTEX_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_NODE_3D_BOX_UPPER_RIGHT_FRONT_VERTEX_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline bool GetNode3DIsIntersectionTestEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_NODE_3D_IS_INTERSECTION_TEST_ENABLED_OFFSET);
    }
    inline bool GetNode3DIsRenderingEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_NODE_3D_IS_RENDERING_ENABLED_OFFSET);
    }
    inline UInt32 GetNode3DScopeBits(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_NODE_3D_SCOPE_BITS_OFFSET);
    }
    inline const UInt32* GetNode3DRenderOrderBin(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_NODE_3D_RENDER_ORDER_BIN_OFFSET);
    }
    inline Int32 GetNode3DRenderOrderRank(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_NODE_3D_RENDER_ORDER_RANK_OFFSET);
    }
    inline Float GetNode3DRenderBenchmark(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_NODE_3D_RENDER_BENCHMARK_OFFSET);
    }
    inline Float GetNode3DAlphaValue(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_NODE_3D_ALPHA_VALUE_OFFSET);
    }
    inline Int32 GetNode3DResolvedAppearanceCollectionAttachmentType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_NODE_3D_RESOLVED_APPEARANCE_COLLECTION_ATTACHMENT_TYPE_OFFSET);
    }
    inline const UInt32* GetNode3DResolvedAppearanceCollectionAttachmentId(const AssetDataHandle& handle)
    {
        return CffGetPtr<UInt32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_NODE_3D_RESOLVED_APPEARANCE_COLLECTION_ATTACHMENT_PTR_OFFSET));
    }
    inline AssetDataHandle GetNode3DResolvedAppearanceCollectionAttachment(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_NODE_3D_RESOLVED_APPEARANCE_COLLECTION_ATTACHMENT_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline Int32 GetNode3DChildrenDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_NODE_3D_CHILDREN_PTR_OFFSET)); 
    }
    inline Int32 GetNode3DChildrenCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_NODE_3D_CHILDREN_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetNode3DChildrenElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_NODE_3D_CHILDREN_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }

}}} //namespaces

#endif //Node3D_CffReader_H
