//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Node2D_CffReader_H
#define Node2D_CffReader_H

#include "NodeCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Node2D
    static const Int32 CFF_NODE_2D_POSITION_OFFSET                                            = (CFF_NODE_SIZE);
    static const Int32 CFF_NODE_2D_ROTATION_OFFSET                                            = (8 + CFF_NODE_2D_POSITION_OFFSET);
    static const Int32 CFF_NODE_2D_SCALE_OFFSET                                               = (4 + CFF_NODE_2D_ROTATION_OFFSET);
    static const Int32 CFF_NODE_2D_PIVOT_POINT_OFFSET                                         = (8 + CFF_NODE_2D_SCALE_OFFSET);
    static const Int32 CFF_NODE_2D_PIVOT_OFFSET_OFFSET                                        = (8 + CFF_NODE_2D_PIVOT_POINT_OFFSET);
    static const Int32 CFF_NODE_2D_IS_RENDERING_ENABLED_OFFSET                                = (8 + CFF_NODE_2D_PIVOT_OFFSET_OFFSET);
    static const Int32 CFF_NODE_2D_SCOPE_BITS_OFFSET                                          = (4 + CFF_NODE_2D_IS_RENDERING_ENABLED_OFFSET);
    static const Int32 CFF_NODE_2D_RENDER_ORDER_RANK_OFFSET                                   = (4 + CFF_NODE_2D_SCOPE_BITS_OFFSET);
    static const Int32 CFF_NODE_2D_DYNAMIC_PROPERTIES_PTR_OFFSET                              = (4 + CFF_NODE_2D_RENDER_ORDER_RANK_OFFSET);
    static const Int32 CFF_NODE_2D_CHILDREN_PTR_OFFSET                                        = (CFF_PTR_SIZE + CFF_NODE_2D_DYNAMIC_PROPERTIES_PTR_OFFSET);
    static const Int32 CFF_NODE_2D_SIZE                                                       = (CFF_PTR_SIZE + CFF_NODE_2D_CHILDREN_PTR_OFFSET);

    // getter methods for Node2D
    inline void GetNode2DPosition(const AssetDataHandle& handle, Float& x, Float& y)
    {
        x = CffGetValSafe<Float>(handle, CFF_NODE_2D_POSITION_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_NODE_2D_POSITION_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline Float GetNode2DRotation(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_NODE_2D_ROTATION_OFFSET);
    }
    inline void GetNode2DScale(const AssetDataHandle& handle, Float& x, Float& y)
    {
        x = CffGetValSafe<Float>(handle, CFF_NODE_2D_SCALE_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_NODE_2D_SCALE_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline void GetNode2DPivotPoint(const AssetDataHandle& handle, Float& x, Float& y)
    {
        x = CffGetValSafe<Float>(handle, CFF_NODE_2D_PIVOT_POINT_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_NODE_2D_PIVOT_POINT_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline void GetNode2DPivotOffset(const AssetDataHandle& handle, Float& x, Float& y)
    {
        x = CffGetValSafe<Float>(handle, CFF_NODE_2D_PIVOT_OFFSET_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_NODE_2D_PIVOT_OFFSET_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline bool GetNode2DIsRenderingEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_NODE_2D_IS_RENDERING_ENABLED_OFFSET);
    }
    inline UInt32 GetNode2DScopeBits(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_NODE_2D_SCOPE_BITS_OFFSET);
    }
    inline Int8 GetNode2DRenderOrderRank(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int8>(handle, CFF_NODE_2D_RENDER_ORDER_RANK_OFFSET);
    }
    inline Int32 GetNode2DDynamicPropertiesCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_NODE_2D_DYNAMIC_PROPERTIES_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle),  offset); 
    }
    inline AssetDataHandle GetNode2DDynamicPropertiesElementAt(const AssetDataHandle& handle, Int32 elementSize, Int32 index)
    {
        Int32 listOffset =  CffGetValSafe<Int32>(handle, CFF_NODE_2D_DYNAMIC_PROPERTIES_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(listHandle, CFF_INT_SIZE + (index * elementSize));
    }
    inline Int32 GetNode2DChildrenDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_NODE_2D_CHILDREN_PTR_OFFSET)); 
    }
    inline Int32 GetNode2DChildrenCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_NODE_2D_CHILDREN_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetNode2DChildrenElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_NODE_2D_CHILDREN_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }

}}} //namespaces

#endif //Node2D_CffReader_H
