//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef MorphingMesh_CffReader_H
#define MorphingMesh_CffReader_H

#include "Node3DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for MorphingMesh
    static const Int32 CFF_MORPHING_MESH_MORPH_ITEMS_PTR_OFFSET                               = (CFF_NODE_3D_SIZE);
    static const Int32 CFF_MORPHING_MESH_SIZE                                                 = (CFF_PTR_SIZE + CFF_MORPHING_MESH_MORPH_ITEMS_PTR_OFFSET);

    // getter methods for MorphingMesh
    inline Int32 GetMorphingMeshMorphItemsCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_MORPHING_MESH_MORPH_ITEMS_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle),  offset); 
    }
    inline AssetDataHandle GetMorphingMeshMorphItemsElementAt(const AssetDataHandle& handle, Int32 elementSize, Int32 index)
    {
        Int32 listOffset =  CffGetValSafe<Int32>(handle, CFF_MORPHING_MESH_MORPH_ITEMS_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(listHandle, CFF_INT_SIZE + (index * elementSize));
    }

}}} //namespaces

#endif //MorphingMesh_CffReader_H
