//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef MorphItem_CffReader_H
#define MorphItem_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for MorphItem
    static const Int32 CFF_MORPH_ITEM_VERTEX_BUFFER_OFFSET                                    = (0);
    static const Int32 CFF_MORPH_ITEM_WEIGHT_OFFSET                                           = (16 + CFF_MORPH_ITEM_VERTEX_BUFFER_OFFSET);
    static const Int32 CFF_MORPH_ITEM_SIZE                                                    = (4 + CFF_MORPH_ITEM_WEIGHT_OFFSET);

    // getter methods for MorphItem
    inline const UInt32* GetMorphItemVertexBuffer(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_MORPH_ITEM_VERTEX_BUFFER_OFFSET);
    }
    inline Float GetMorphItemWeight(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_MORPH_ITEM_WEIGHT_OFFSET);
    }

}}} //namespaces

#endif //MorphItem_CffReader_H
