//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef LodNode_CffReader_H
#define LodNode_CffReader_H

#include "Node3DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for LodNode
    static const Int32 CFF_LOD_NODE_STRATEGY_PTR_OFFSET                                       = (CFF_NODE_3D_SIZE);
    static const Int32 CFF_LOD_NODE_CRITERION_PTR_OFFSET                                      = (CFF_PTR_SIZE + CFF_LOD_NODE_STRATEGY_PTR_OFFSET);
    static const Int32 CFF_LOD_NODE_LOD_NODE_ITEM_INFO_LIST_PTR_OFFSET                        = (CFF_PTR_SIZE + CFF_LOD_NODE_CRITERION_PTR_OFFSET);
    static const Int32 CFF_LOD_NODE_SIZE                                                      = (CFF_PTR_SIZE + CFF_LOD_NODE_LOD_NODE_ITEM_INFO_LIST_PTR_OFFSET);

    // getter methods for LodNode
    inline AssetDataHandle GetLodNodeStrategy(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_LOD_NODE_STRATEGY_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline AssetDataHandle GetLodNodeCriterion(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_LOD_NODE_CRITERION_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline Int32 GetLodNodeLodNodeItemInfoListCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_LOD_NODE_LOD_NODE_ITEM_INFO_LIST_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle),  offset); 
    }
    inline AssetDataHandle GetLodNodeLodNodeItemInfoListElementAt(const AssetDataHandle& handle, Int32 elementSize, Int32 index)
    {
        Int32 listOffset =  CffGetValSafe<Int32>(handle, CFF_LOD_NODE_LOD_NODE_ITEM_INFO_LIST_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(listHandle, CFF_INT_SIZE + (index * elementSize));
    }

}}} //namespaces

#endif //LodNode_CffReader_H
