//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Light_CffReader_H
#define Light_CffReader_H

#include "Node3DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Light
    static const Int32 CFF_LIGHT_LIGHT_TYPE_OFFSET                                            = (CFF_NODE_3D_SIZE);
    static const Int32 CFF_LIGHT_AMBIENT_OFFSET                                               = (4 + CFF_LIGHT_LIGHT_TYPE_OFFSET);
    static const Int32 CFF_LIGHT_DIFFUSE_OFFSET                                               = (16 + CFF_LIGHT_AMBIENT_OFFSET);
    static const Int32 CFF_LIGHT_SPECULAR_OFFSET                                              = (16 + CFF_LIGHT_DIFFUSE_OFFSET);
    static const Int32 CFF_LIGHT_DIRECTION_OFFSET                                             = (16 + CFF_LIGHT_SPECULAR_OFFSET);
    static const Int32 CFF_LIGHT_RANGE_OFFSET                                                 = (12 + CFF_LIGHT_DIRECTION_OFFSET);
    static const Int32 CFF_LIGHT_CONSTANT_ATTENUATION_OFFSET                                  = (4 + CFF_LIGHT_RANGE_OFFSET);
    static const Int32 CFF_LIGHT_LINEAR_ATTENUATION_OFFSET                                    = (4 + CFF_LIGHT_CONSTANT_ATTENUATION_OFFSET);
    static const Int32 CFF_LIGHT_QUADRATIC_ATTENUATION_OFFSET                                 = (4 + CFF_LIGHT_LINEAR_ATTENUATION_OFFSET);
    static const Int32 CFF_LIGHT_SPOT_ANGLE_OFFSET                                            = (4 + CFF_LIGHT_QUADRATIC_ATTENUATION_OFFSET);
    static const Int32 CFF_LIGHT_SPOT_EXPONENT_OFFSET                                         = (4 + CFF_LIGHT_SPOT_ANGLE_OFFSET);
    static const Int32 CFF_LIGHT_IS_ATTENUATION_ENABLED_OFFSET                                = (4 + CFF_LIGHT_SPOT_EXPONENT_OFFSET);
    static const Int32 CFF_LIGHT_SIZE                                                         = (4 + CFF_LIGHT_IS_ATTENUATION_ENABLED_OFFSET);

    // getter methods for Light
    inline Int32 GetLightLightType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_LIGHT_LIGHT_TYPE_OFFSET);
    }
    inline void GetLightAmbient(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_LIGHT_AMBIENT_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_LIGHT_AMBIENT_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_LIGHT_AMBIENT_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_LIGHT_AMBIENT_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline void GetLightDiffuse(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_LIGHT_DIFFUSE_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_LIGHT_DIFFUSE_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_LIGHT_DIFFUSE_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_LIGHT_DIFFUSE_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline void GetLightSpecular(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_LIGHT_SPECULAR_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_LIGHT_SPECULAR_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_LIGHT_SPECULAR_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_LIGHT_SPECULAR_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline void GetLightDirection(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_LIGHT_DIRECTION_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_LIGHT_DIRECTION_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_LIGHT_DIRECTION_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline Float GetLightRange(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_LIGHT_RANGE_OFFSET);
    }
    inline Float GetLightConstantAttenuation(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_LIGHT_CONSTANT_ATTENUATION_OFFSET);
    }
    inline Float GetLightLinearAttenuation(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_LIGHT_LINEAR_ATTENUATION_OFFSET);
    }
    inline Float GetLightQuadraticAttenuation(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_LIGHT_QUADRATIC_ATTENUATION_OFFSET);
    }
    inline Float GetLightSpotAngle(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_LIGHT_SPOT_ANGLE_OFFSET);
    }
    inline Float GetLightSpotExponent(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_LIGHT_SPOT_EXPONENT_OFFSET);
    }
    inline bool GetLightIsAttenuationEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_LIGHT_IS_ATTENUATION_ENABLED_OFFSET);
    }

}}} //namespaces

#endif //Light_CffReader_H
