//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef LibraryHeader_CffReader_H
#define LibraryHeader_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    static const UInt32 CFF_LIB_HEADER_SIZE_OFFSET = 0U;
    static const UInt32 CFF_LIB_ELEMENT_COUNT_OFFSET = 4U + CFF_LIB_HEADER_SIZE_OFFSET;
    static const UInt32 CFF_LIB_MAX_ELEMENT_SIZE = 4U + CFF_LIB_ELEMENT_COUNT_OFFSET;
    static const UInt32 CFF_LIB_ELEMENTS_OFFSET = 4U + CFF_LIB_MAX_ELEMENT_SIZE;

    static const UInt32 CFF_LIB_ELEMENT_ID_OFFSET = 0U;
    static const UInt32 CFF_LIB_ELEMENT_NAME_OFFSET_OFFSET = 16U + CFF_LIB_ELEMENT_ID_OFFSET;
    static const UInt32 CFF_LIB_ELEMENT_DATA_OFFSET_OFFSET = 4U + CFF_LIB_ELEMENT_NAME_OFFSET_OFFSET;
    static const UInt32 CFF_LIB_ELEMENT_DATA_SIZE_OFFSET = 4U + CFF_LIB_ELEMENT_DATA_OFFSET_OFFSET;
    static const UInt32 CFF_LIB_ELEMENT_REGION_DATA_SIZE_OFFSET = 4U + CFF_LIB_ELEMENT_DATA_SIZE_OFFSET;
    static const UInt32 CFF_LIB_ELEMENT_UNCOMPRESSED_SIZE_OFFSET = 4U + CFF_LIB_ELEMENT_REGION_DATA_SIZE_OFFSET;
    static const UInt32 CFF_LIB_ELEMENT_SIZE = 4U + CFF_LIB_ELEMENT_UNCOMPRESSED_SIZE_OFFSET;

    inline UInt32 GetLibHeaderSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_LIB_HEADER_SIZE_OFFSET);
    }

    inline Int32 GetLibElementCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_LIB_ELEMENT_COUNT_OFFSET);
    }

    inline Int32 GetLibMaxElementSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_LIB_MAX_ELEMENT_SIZE);
    }

    inline AssetDataHandle GetLibElement(const AssetDataHandle& handle, Int32 index)
    {
        return CffGetHandle(handle, CFF_LIB_ELEMENTS_OFFSET + (index * CFF_LIB_ELEMENT_SIZE));
    }

    inline const UInt32* GetLibElementId(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_LIB_ELEMENT_ID_OFFSET);
    }

    inline UInt32 GetLibElementName(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_LIB_ELEMENT_NAME_OFFSET_OFFSET);
    }

    inline Int32 GetLibElementUncompressedSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_LIB_ELEMENT_UNCOMPRESSED_SIZE_OFFSET);
    }

    inline UInt32 GetLibElementDataOffset(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_LIB_ELEMENT_DATA_OFFSET_OFFSET);
    }

    inline Int32 GetLibElementDataSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_LIB_ELEMENT_DATA_SIZE_OFFSET);
    }

    inline Int32 GetLibElementRegionDataSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_LIB_ELEMENT_REGION_DATA_SIZE_OFFSET);
    }


}}} //namespaces

#endif //LibraryHeader_CffReader_H
