//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef LibraryCollectionInfo_CffReader_H
#define LibraryCollectionInfo_CffReader_H

#include "AssetHeaderCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    static const UInt32 CFF_ASSET_LIBINFO_COUNT_OFFSET = CFF_ASSET_HEADER_SIZE;
    static const UInt32 CFF_ASSET_LIBINFO_TYPE_OFFSET = 0U;
    static const UInt32 CFF_ASSET_LIBINFO_HEADER_OFFSET_OFFSET = 4U + CFF_ASSET_LIBINFO_TYPE_OFFSET;
    static const UInt32 CFF_ASSET_LIBINFO_DATA_OFFSET_OFFSET = 4U + CFF_ASSET_LIBINFO_HEADER_OFFSET_OFFSET;
    static const UInt32 CFF_ASSET_LIBINFO_SIZE_OFFSET = 4U + CFF_ASSET_LIBINFO_DATA_OFFSET_OFFSET;
    static const UInt32 CFF_ASSET_LIBINFO_SIZE = 4U + CFF_ASSET_LIBINFO_SIZE_OFFSET;

    inline Int32 GetAssetLibInfoCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, 0);
    }

    inline Int32 GetAssetLibInfoType(const AssetDataHandle& handle, Int32 index)
    {
        return CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_ASSET_LIBINFO_TYPE_OFFSET + (index * CFF_ASSET_LIBINFO_SIZE));
    }

    inline UInt32 GetAssetLibInfoHeaderOffset(const AssetDataHandle& handle, Int32 index)
    {
        return CffGetValSafe<UInt32>(handle, CFF_INT_SIZE + CFF_ASSET_LIBINFO_HEADER_OFFSET_OFFSET + (index * CFF_ASSET_LIBINFO_SIZE));
    }

    inline UInt32 GetAssetLibInfoDataOffset(const AssetDataHandle& handle, UInt32 index)
    {
        return CffGetValSafe<UInt32>(handle, CFF_INT_SIZE + CFF_ASSET_LIBINFO_DATA_OFFSET_OFFSET + (index * CFF_ASSET_LIBINFO_SIZE));
    }


}}} //namespaces

#endif //LibraryCollectionInfo_CffReader_H
