//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef ItemHeader_CffReader_H
#define ItemHeader_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    static const UInt32 CFF_HEADER_SIZE_OFFSET = 0U;

    static const UInt32 CFF_REGION_OFFSET_OFFSET = 0U;
    static const UInt32 CFF_REGION_SIZE_OFFSET = 4U + CFF_REGION_OFFSET_OFFSET;
    static const UInt32 CFF_REGION_UNCOMPRESSED_SIZE_OFFSET = 4U + CFF_REGION_SIZE_OFFSET;
    static const UInt32 CFF_REGION_SIZE = 4U + CFF_REGION_UNCOMPRESSED_SIZE_OFFSET;

    static const UInt32 CFF_ITEM_ID_OFFSET = 0U;
    static const UInt32 CFF_ITEM_PARENT_ID_INDEX_OFFSET = 4U + CFF_ITEM_ID_OFFSET;
    static const UInt32 CFF_ITEM_SIBLING_ID_INDEX_OFFSET = 4U + CFF_ITEM_PARENT_ID_INDEX_OFFSET;
    static const UInt32 CFF_ITEM_CHILD_ID_INDEX_OFFSET = 4U + CFF_ITEM_SIBLING_ID_INDEX_OFFSET;
    static const UInt32 CFF_ITEM_NAME_OFFSET_OFFSET = 4U + CFF_ITEM_CHILD_ID_INDEX_OFFSET;
    static const UInt32 CFF_ITEM_TYPE_OFFSET = 4U + CFF_ITEM_NAME_OFFSET_OFFSET;
    static const UInt32 CFF_ITEM_SIZE = 4U + CFF_ITEM_TYPE_OFFSET;

    inline UInt32 GetItemHeaderSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, 0);
    }

    inline AssetDataHandle GetItemHeaderHandle(const AssetDataHandle& handle)
    {
        return CffGetHandle(CffGetAssetLibHandle(handle), CFF_INT_SIZE);
    }

    inline Int32 GetRegionCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, 0);
    }

    inline AssetDataHandle GetRegion(const AssetDataHandle& handle, Int32 index)
    {
        return CffGetHandle(handle, CFF_INT_SIZE + (index * CFF_REGION_SIZE));
    }

    inline UInt32 GetRegionDataOffset(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_REGION_OFFSET_OFFSET);
    }

    inline Int32 GetRegionDataSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_REGION_SIZE_OFFSET);
    }

    inline Int32 GetRegionDataUncompressedSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_REGION_UNCOMPRESSED_SIZE_OFFSET);
    }

    inline AssetDataHandle GetItemListHandle(const AssetDataHandle& handle)
    {
        return GetRegion(handle, GetRegionCount(handle));
    }

    inline Int32 GetItemCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, 0);
    }

    inline AssetDataHandle GetItem(const AssetDataHandle& handle, Int32 index)
    {
        return CffGetHandle(handle, CFF_INT_SIZE + (index * CFF_ITEM_SIZE));
    }

    inline Id GetItemId(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Id>(handle, CFF_ITEM_ID_OFFSET);
    }

    inline Int32 GetItemSiblingIndex(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ITEM_SIBLING_ID_INDEX_OFFSET);
    }

    inline Int32 GetItemChildIndex(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ITEM_CHILD_ID_INDEX_OFFSET);
    }

    inline Int32 GetItemParentIndex(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ITEM_PARENT_ID_INDEX_OFFSET);
    }

    inline UInt32 GetItemName(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ITEM_NAME_OFFSET_OFFSET);
    }

    inline Int32 GetItemType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ITEM_TYPE_OFFSET);
    }

    inline AssetDataHandle GetItemDataHandle(const AssetDataHandle& handle)
    {
        const AssetDataHandle& itemListHandle = GetItemListHandle(GetItemHeaderHandle(handle));
        return GetItem(itemListHandle, GetItemCount(itemListHandle));
    }



}}} //namespaces

#endif //ItemHeader_CffReader_H
