//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef IntAnimationKeyframe_CffReader_H
#define IntAnimationKeyframe_CffReader_H

#include "BaseAnimationKeyframeCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for IntAnimationKeyframe
    static const Int32 CFF_INT_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET                           = (CFF_BASE_ANIMATION_KEYFRAME_SIZE);
    static const Int32 CFF_INT_ANIMATION_KEYFRAME_SIZE                                        = (CFF_PTR_SIZE + CFF_INT_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET);

    // getter methods for IntAnimationKeyframe
    inline Int32 GetIntAnimationKeyframeValuesCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_INT_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET);
    }
    inline Int32 GetIntAnimationKeyframeValuesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        return CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_INT_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET + (index * CFF_INT_SIZE));
    }

}}} //namespaces

#endif //IntAnimationKeyframe_CffReader_H
