//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Int16AnimationKeyframe_CffReader_H
#define Int16AnimationKeyframe_CffReader_H

#include "BaseAnimationKeyframeCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Int16AnimationKeyframe
    static const Int32 CFF_INT_16ANIMATION_KEYFRAME_VALUES_PTR_OFFSET                         = (CFF_BASE_ANIMATION_KEYFRAME_SIZE);
    static const Int32 CFF_INT_16ANIMATION_KEYFRAME_SIZE                                      = (CFF_PTR_SIZE + CFF_INT_16ANIMATION_KEYFRAME_VALUES_PTR_OFFSET);

    // getter methods for Int16AnimationKeyframe
    inline Int32 GetInt16AnimationKeyframeValuesCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_INT_16ANIMATION_KEYFRAME_VALUES_PTR_OFFSET);
    }
    inline Int16 GetInt16AnimationKeyframeValuesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        return CffGetValSafe<Int16>(handle, CFF_INT_SIZE + CFF_INT_16ANIMATION_KEYFRAME_VALUES_PTR_OFFSET + (index * CFF_INT16_SIZE));
    }

}}} //namespaces

#endif //Int16AnimationKeyframe_CffReader_H
