//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef GridLayout_CffReader_H
#define GridLayout_CffReader_H

#include "LayoutCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for GridLayout
    static const Int32 CFF_GRID_LAYOUT_ROW_COUNT_OFFSET                                       = (CFF_LAYOUT_SIZE);
    static const Int32 CFF_GRID_LAYOUT_ROW_HEIGHTS_PTR_OFFSET                                 = (4 + CFF_GRID_LAYOUT_ROW_COUNT_OFFSET);
    static const Int32 CFF_GRID_LAYOUT_COLUMN_COUNT_OFFSET                                    = (CFF_PTR_SIZE + CFF_GRID_LAYOUT_ROW_HEIGHTS_PTR_OFFSET);
    static const Int32 CFF_GRID_LAYOUT_COLUMN_WIDTHS_PTR_OFFSET                               = (4 + CFF_GRID_LAYOUT_COLUMN_COUNT_OFFSET);
    static const Int32 CFF_GRID_LAYOUT_SIZE                                                   = (CFF_PTR_SIZE + CFF_GRID_LAYOUT_COLUMN_WIDTHS_PTR_OFFSET);

    // getter methods for GridLayout
    inline UInt8 GetGridLayoutRowCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt8>(handle, CFF_GRID_LAYOUT_ROW_COUNT_OFFSET);
    }
    inline Float const * GetGridLayoutRowHeights(const AssetDataHandle& handle)
    {
        return CffGetPtr<Float>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_GRID_LAYOUT_ROW_HEIGHTS_PTR_OFFSET)), 0);
    }
    inline Float GetGridLayoutRowHeightsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_GRID_LAYOUT_ROW_HEIGHTS_PTR_OFFSET));
        return CffGetValSafe<Float>(listHandle, (index * CFF_FLOAT_SIZE));
    }
    inline UInt8 GetGridLayoutColumnCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt8>(handle, CFF_GRID_LAYOUT_COLUMN_COUNT_OFFSET);
    }
    inline Float const * GetGridLayoutColumnWidths(const AssetDataHandle& handle)
    {
        return CffGetPtr<Float>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_GRID_LAYOUT_COLUMN_WIDTHS_PTR_OFFSET)), 0);
    }
    inline Float GetGridLayoutColumnWidthsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_GRID_LAYOUT_COLUMN_WIDTHS_PTR_OFFSET));
        return CffGetValSafe<Float>(listHandle, (index * CFF_FLOAT_SIZE));
    }

}}} //namespaces

#endif //GridLayout_CffReader_H
