//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef FontInfo_CffReader_H
#define FontInfo_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for FontInfo
    static const Int32 CFF_FONT_INFO_FONT_OFFSET                                              = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_FONT_INFO_SIZE_OFFSET                                              = (16 + CFF_FONT_INFO_FONT_OFFSET);
    static const Int32 CFF_FONT_INFO_FACE_INDEX_OFFSET                                        = (4 + CFF_FONT_INFO_SIZE_OFFSET);
    static const Int32 CFF_FONT_INFO_SCALE_OFFSET                                             = (4 + CFF_FONT_INFO_FACE_INDEX_OFFSET);
    static const Int32 CFF_FONT_INFO_SIZE                                                     = (8 + CFF_FONT_INFO_SCALE_OFFSET);

    // getter methods for FontInfo
    inline const UInt32* GetFontInfoFont(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_FONT_INFO_FONT_OFFSET);
    }
    inline Int16 GetFontInfoSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int16>(handle, CFF_FONT_INFO_SIZE_OFFSET);
    }
    inline UInt8 GetFontInfoFaceIndex(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt8>(handle, CFF_FONT_INFO_FACE_INDEX_OFFSET);
    }
    inline void GetFontInfoScale(const AssetDataHandle& handle, Float& x, Float& y)
    {
        x = CffGetValSafe<Float>(handle, CFF_FONT_INFO_SCALE_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_FONT_INFO_SCALE_OFFSET + (1 * CFF_FLOAT_SIZE));
    }

}}} //namespaces

#endif //FontInfo_CffReader_H
