//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef FloatAnimationKeyframe_CffReader_H
#define FloatAnimationKeyframe_CffReader_H

#include "BaseAnimationKeyframeCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for FloatAnimationKeyframe
    static const Int32 CFF_FLOAT_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET                         = (CFF_BASE_ANIMATION_KEYFRAME_SIZE);
    static const Int32 CFF_FLOAT_ANIMATION_KEYFRAME_SIZE                                      = (CFF_PTR_SIZE + CFF_FLOAT_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET);

    // getter methods for FloatAnimationKeyframe
    inline Int32 GetFloatAnimationKeyframeValuesCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_FLOAT_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET);
    }
    inline Float GetFloatAnimationKeyframeValuesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        return CffGetValSafe<Float>(handle, CFF_INT_SIZE + CFF_FLOAT_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET + (index * CFF_FLOAT_SIZE));
    }

}}} //namespaces

#endif //FloatAnimationKeyframe_CffReader_H
