//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef ExponentialFunction_CffReader_H
#define ExponentialFunction_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for ExponentialFunction
    static const Int32 CFF_EXPONENTIAL_FUNCTION_ITEM_SIZE_OFFSET                              = (0);
    static const Int32 CFF_EXPONENTIAL_FUNCTION_EXPONENT_OFFSET                               = (4 + CFF_EXPONENTIAL_FUNCTION_ITEM_SIZE_OFFSET);
    static const Int32 CFF_EXPONENTIAL_FUNCTION_SIZE                                          = (4 + CFF_EXPONENTIAL_FUNCTION_EXPONENT_OFFSET);

    // getter methods for ExponentialFunction
    inline Int32 GetExponentialFunctionItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_EXPONENTIAL_FUNCTION_ITEM_SIZE_OFFSET);
    }
    inline Float GetExponentialFunctionExponent(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_EXPONENTIAL_FUNCTION_EXPONENT_OFFSET);
    }

}}} //namespaces

#endif //ExponentialFunction_CffReader_H
