//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef ElasticFunction_CffReader_H
#define ElasticFunction_CffReader_H

#include "ExponentialFunctionCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for ElasticFunction
    static const Int32 CFF_ELASTIC_FUNCTION_OSCILLATION_COUNT_OFFSET                          = (CFF_EXPONENTIAL_FUNCTION_SIZE);
    static const Int32 CFF_ELASTIC_FUNCTION_SIZE                                              = (4 + CFF_ELASTIC_FUNCTION_OSCILLATION_COUNT_OFFSET);

    // getter methods for ElasticFunction
    inline UInt8 GetElasticFunctionOscillationCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt8>(handle, CFF_ELASTIC_FUNCTION_OSCILLATION_COUNT_OFFSET);
    }

}}} //namespaces

#endif //ElasticFunction_CffReader_H
