//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef EaseInterpolation_CffReader_H
#define EaseInterpolation_CffReader_H

#include "BaseAnimationInterpolationCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for EaseInterpolation
    static const Int32 CFF_EASE_INTERPOLATION_CONTROL_POINTS_DUMMY_OFFSET                     = (CFF_BASE_ANIMATION_INTERPOLATION_SIZE);
    static const Int32 CFF_EASE_INTERPOLATION_DIRECTION_OFFSET                                = (4 + CFF_EASE_INTERPOLATION_CONTROL_POINTS_DUMMY_OFFSET);
    static const Int32 CFF_EASE_INTERPOLATION_FUNCTION_TYPE_OFFSET                            = (4 + CFF_EASE_INTERPOLATION_DIRECTION_OFFSET);
    static const Int32 CFF_EASE_INTERPOLATION_INTERPOLATION_FUNCTION_PTR_OFFSET               = (4 + CFF_EASE_INTERPOLATION_FUNCTION_TYPE_OFFSET);
    static const Int32 CFF_EASE_INTERPOLATION_SIZE                                            = (CFF_PTR_SIZE + CFF_EASE_INTERPOLATION_INTERPOLATION_FUNCTION_PTR_OFFSET);

    // getter methods for EaseInterpolation
    inline Int32 GetEaseInterpolationControlPointsDummy(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_EASE_INTERPOLATION_CONTROL_POINTS_DUMMY_OFFSET);
    }
    inline Int32 GetEaseInterpolationDirection(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_EASE_INTERPOLATION_DIRECTION_OFFSET);
    }
    inline Int32 GetEaseInterpolationFunctionType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_EASE_INTERPOLATION_FUNCTION_TYPE_OFFSET);
    }
    inline AssetDataHandle GetEaseInterpolationInterpolationFunction(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_EASE_INTERPOLATION_INTERPOLATION_FUNCTION_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //EaseInterpolation_CffReader_H
