//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef DynamicPropertyItemInfo_CffReader_H
#define DynamicPropertyItemInfo_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for DynamicPropertyItemInfo
    static const Int32 CFF_DYNAMIC_PROPERTY_ITEM_INFO_NAME_OFFSET                             = (0);
    static const Int32 CFF_DYNAMIC_PROPERTY_ITEM_INFO_VALUE_PTR_OFFSET                        = (4 + CFF_DYNAMIC_PROPERTY_ITEM_INFO_NAME_OFFSET);
    static const Int32 CFF_DYNAMIC_PROPERTY_ITEM_INFO_SIZE                                    = (CFF_PTR_SIZE + CFF_DYNAMIC_PROPERTY_ITEM_INFO_VALUE_PTR_OFFSET);

    // getter methods for DynamicPropertyItemInfo
    inline Int32 GetDynamicPropertyItemInfoName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_DYNAMIC_PROPERTY_ITEM_INFO_NAME_OFFSET);
        return nameIndex;
    }
    inline const Char* GetDynamicPropertyItemInfoValue(const AssetDataHandle& handle)
    {
        return CffGetPtr<Char>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_DYNAMIC_PROPERTY_ITEM_INFO_VALUE_PTR_OFFSET)), CFF_STRINGLENGTH_SIZE);
    }

}}} //namespaces

#endif //DynamicPropertyItemInfo_CffReader_H
