//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef ControlNodeAnimationNode_CffReader_H
#define ControlNodeAnimationNode_CffReader_H

#include "AnimationNodeBaseCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for ControlNodeAnimationNode
    static const Int32 CFF_CONTROL_NODE_ANIMATION_NODE_CHAIN_LENGTH_OFFSET                    = (CFF_ANIMATION_NODE_BASE_SIZE);
    static const Int32 CFF_CONTROL_NODE_ANIMATION_NODE_CONTROL_NODES_PTR_OFFSET               = (4 + CFF_CONTROL_NODE_ANIMATION_NODE_CHAIN_LENGTH_OFFSET);
    static const Int32 CFF_CONTROL_NODE_ANIMATION_NODE_COMPOSITE_ANIMATION_OFFSET             = (CFF_PTR_SIZE + CFF_CONTROL_NODE_ANIMATION_NODE_CONTROL_NODES_PTR_OFFSET);
    static const Int32 CFF_CONTROL_NODE_ANIMATION_NODE_SIZE                                   = (16 + CFF_CONTROL_NODE_ANIMATION_NODE_COMPOSITE_ANIMATION_OFFSET);

    // getter methods for ControlNodeAnimationNode
    inline Int32 GetControlNodeAnimationNodeChainLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CONTROL_NODE_ANIMATION_NODE_CHAIN_LENGTH_OFFSET);
    }
    inline const UInt32* const * GetControlNodeAnimationNodeControlNodes(const AssetDataHandle& handle)
    {
        return CffGetPtr<const UInt32*>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_CONTROL_NODE_ANIMATION_NODE_CONTROL_NODES_PTR_OFFSET)), 0);
    }
    inline const UInt32* GetControlNodeAnimationNodeControlNodesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_CONTROL_NODE_ANIMATION_NODE_CONTROL_NODES_PTR_OFFSET));
        return CffGetPtrSafe<UInt32>(listHandle, (index * CFF_ITEMID_SIZE));
    }
    inline const UInt32* GetControlNodeAnimationNodeCompositeAnimation(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_CONTROL_NODE_ANIMATION_NODE_COMPOSITE_ANIMATION_OFFSET);
    }

}}} //namespaces

#endif //ControlNodeAnimationNode_CffReader_H
