//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef CompositePropertyDefinitionCollection_CffReader_H
#define CompositePropertyDefinitionCollection_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for CompositePropertyDefinitionCollection
    static const Int32 CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_ITEM_SIZE_OFFSET          = (0);
    static const Int32 CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_ITEM_TYPE_OFFSET          = (4 + CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_ITEM_SIZE_OFFSET);
    static const Int32 CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_CANDERA_NAME_OFFSET       = (4 + CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_ITEM_TYPE_OFFSET);
    static const Int32 CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_CANDERA_ID_OFFSET         = (4 + CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_CANDERA_NAME_OFFSET);
    static const Int32 CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_CHILDREN_PTR_OFFSET       = (16 + CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_CANDERA_ID_OFFSET);
    static const Int32 CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_SIZE                      = (CFF_PTR_SIZE + CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_CHILDREN_PTR_OFFSET);

    // getter methods for CompositePropertyDefinitionCollection
    inline Int32 GetCompositePropertyDefinitionCollectionItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_ITEM_SIZE_OFFSET);
    }
    inline Int32 GetCompositePropertyDefinitionCollectionItemType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_ITEM_TYPE_OFFSET);
    }
    inline Int32 GetCompositePropertyDefinitionCollectionCanderaName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_CANDERA_NAME_OFFSET);
        return nameIndex;
    }
    inline const UInt32* GetCompositePropertyDefinitionCollectionCanderaId(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_CANDERA_ID_OFFSET);
    }
    inline Int32 GetCompositePropertyDefinitionCollectionChildrenDataSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_CHILDREN_PTR_OFFSET);
    }
    inline Int32 GetCompositePropertyDefinitionCollectionChildrenCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_CHILDREN_PTR_OFFSET);
    }
    inline AssetDataHandle GetCompositePropertyDefinitionCollectionChildrenElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_INT_SIZE + CFF_COMPOSITE_PROPERTY_DEFINITION_COLLECTION_CHILDREN_PTR_OFFSET + (index * CFF_PTR_SIZE));
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //CompositePropertyDefinitionCollection_CffReader_H
