//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef CompositePropertyDefinition_CffReader_H
#define CompositePropertyDefinition_CffReader_H

#include "PublicPropertyDefinitionCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for CompositePropertyDefinition
    static const Int32 CFF_COMPOSITE_PROPERTY_DEFINITION_WIDGET_PATH_LENGTH_OFFSET            = (CFF_PUBLIC_PROPERTY_DEFINITION_SIZE);
    static const Int32 CFF_COMPOSITE_PROPERTY_DEFINITION_WIDGET_PATH_PTR_OFFSET               = (4 + CFF_COMPOSITE_PROPERTY_DEFINITION_WIDGET_PATH_LENGTH_OFFSET);
    static const Int32 CFF_COMPOSITE_PROPERTY_DEFINITION_WIDGET_PROPERTY_NAME_PTR_OFFSET      = (CFF_PTR_SIZE + CFF_COMPOSITE_PROPERTY_DEFINITION_WIDGET_PATH_PTR_OFFSET);
    static const Int32 CFF_COMPOSITE_PROPERTY_DEFINITION_SIZE                                 = (CFF_PTR_SIZE + CFF_COMPOSITE_PROPERTY_DEFINITION_WIDGET_PROPERTY_NAME_PTR_OFFSET);

    // getter methods for CompositePropertyDefinition
    inline Int32 GetCompositePropertyDefinitionWidgetPathLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_COMPOSITE_PROPERTY_DEFINITION_WIDGET_PATH_LENGTH_OFFSET);
    }
    inline const UInt32* const * GetCompositePropertyDefinitionWidgetPath(const AssetDataHandle& handle)
    {
        return CffGetPtr<const UInt32*>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_COMPOSITE_PROPERTY_DEFINITION_WIDGET_PATH_PTR_OFFSET)), 0);
    }
    inline const UInt32* GetCompositePropertyDefinitionWidgetPathElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_COMPOSITE_PROPERTY_DEFINITION_WIDGET_PATH_PTR_OFFSET));
        return CffGetPtrSafe<UInt32>(listHandle, (index * CFF_ITEMID_SIZE));
    }
    inline const Char* GetCompositePropertyDefinitionWidgetPropertyName(const AssetDataHandle& handle)
    {
        return CffGetPtr<Char>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_COMPOSITE_PROPERTY_DEFINITION_WIDGET_PROPERTY_NAME_PTR_OFFSET)), CFF_STRINGLENGTH_SIZE);
    }

}}} //namespaces

#endif //CompositePropertyDefinition_CffReader_H
