//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef CompositeNode_CffReader_H
#define CompositeNode_CffReader_H

#include "Node3DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for CompositeNode
    static const Int32 CFF_COMPOSITE_NODE_THIS_NODE_PTR_OFFSET                                = (CFF_NODE_3D_SIZE);
    static const Int32 CFF_COMPOSITE_NODE_COMPOSITE_INTERFACE_OFFSET                          = (CFF_PTR_SIZE + CFF_COMPOSITE_NODE_THIS_NODE_PTR_OFFSET);
    static const Int32 CFF_COMPOSITE_NODE_COMPOSITE_PROPERTIES_PTR_OFFSET                     = (16 + CFF_COMPOSITE_NODE_COMPOSITE_INTERFACE_OFFSET);
    static const Int32 CFF_COMPOSITE_NODE_SIZE                                                = (CFF_PTR_SIZE + CFF_COMPOSITE_NODE_COMPOSITE_PROPERTIES_PTR_OFFSET);

    // getter methods for CompositeNode
    inline const Char* GetCompositeNodeThisNode(const AssetDataHandle& handle)
    {
        return CffGetPtr<Char>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_COMPOSITE_NODE_THIS_NODE_PTR_OFFSET)), CFF_STRINGLENGTH_SIZE);
    }
    inline const UInt32* GetCompositeNodeCompositeInterface(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_COMPOSITE_NODE_COMPOSITE_INTERFACE_OFFSET);
    }
    inline AssetDataHandle GetCompositeNodeCompositeProperties(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_COMPOSITE_NODE_COMPOSITE_PROPERTIES_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //CompositeNode_CffReader_H
