//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Composite3D_CffReader_H
#define Composite3D_CffReader_H

#include "Scene3DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Composite3D
    static const Int32 CFF_COMPOSITE_3D_ANCHORS_PTR_OFFSET                                    = (CFF_SCENE_3D_SIZE);
    static const Int32 CFF_COMPOSITE_3D_COMPOSITE_PROPERTIES_PTR_OFFSET                       = (CFF_PTR_SIZE + CFF_COMPOSITE_3D_ANCHORS_PTR_OFFSET);
    static const Int32 CFF_COMPOSITE_3D_COMPOSITE_ANIMATIONS_LENGTH_OFFSET                    = (CFF_PTR_SIZE + CFF_COMPOSITE_3D_COMPOSITE_PROPERTIES_PTR_OFFSET);
    static const Int32 CFF_COMPOSITE_3D_COMPOSITE_ANIMATIONS_PTR_OFFSET                       = (4 + CFF_COMPOSITE_3D_COMPOSITE_ANIMATIONS_LENGTH_OFFSET);
    static const Int32 CFF_COMPOSITE_3D_IS_CANVAS_COMPOSITE_OFFSET                            = (CFF_PTR_SIZE + CFF_COMPOSITE_3D_COMPOSITE_ANIMATIONS_PTR_OFFSET);
    static const Int32 CFF_COMPOSITE_3D_IS_LAYOUT_ENABLED_OFFSET                              = (4 + CFF_COMPOSITE_3D_IS_CANVAS_COMPOSITE_OFFSET);
    static const Int32 CFF_COMPOSITE_3D_LAYOUT_PTR_OFFSET                                     = (4 + CFF_COMPOSITE_3D_IS_LAYOUT_ENABLED_OFFSET);
    static const Int32 CFF_COMPOSITE_3D_SIZE                                                  = (CFF_PTR_SIZE + CFF_COMPOSITE_3D_LAYOUT_PTR_OFFSET);

    // getter methods for Composite3D
    inline AssetDataHandle GetComposite3DAnchors(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_COMPOSITE_3D_ANCHORS_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline AssetDataHandle GetComposite3DCompositeProperties(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_COMPOSITE_3D_COMPOSITE_PROPERTIES_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline Int32 GetComposite3DCompositeAnimationsLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_COMPOSITE_3D_COMPOSITE_ANIMATIONS_LENGTH_OFFSET);
    }
    inline const UInt32* const * GetComposite3DCompositeAnimations(const AssetDataHandle& handle)
    {
        return CffGetPtr<const UInt32*>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_COMPOSITE_3D_COMPOSITE_ANIMATIONS_PTR_OFFSET)), 0);
    }
    inline const UInt32* GetComposite3DCompositeAnimationsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_COMPOSITE_3D_COMPOSITE_ANIMATIONS_PTR_OFFSET));
        return CffGetPtrSafe<UInt32>(listHandle, (index * CFF_ITEMID_SIZE));
    }
    inline bool GetComposite3DIsCanvasComposite(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_COMPOSITE_3D_IS_CANVAS_COMPOSITE_OFFSET);
    }
    inline bool GetComposite3DIsLayoutEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_COMPOSITE_3D_IS_LAYOUT_ENABLED_OFFSET);
    }
    inline AssetDataHandle GetComposite3DLayout(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_COMPOSITE_3D_LAYOUT_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //Composite3D_CffReader_H
