//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef ClearMode_CffReader_H
#define ClearMode_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for ClearMode
    static const Int32 CFF_CLEAR_MODE_IS_COLOR_CLEAR_ENABLED_OFFSET                           = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_CLEAR_MODE_CLEAR_COLOR_OFFSET                                      = (4 + CFF_CLEAR_MODE_IS_COLOR_CLEAR_ENABLED_OFFSET);
    static const Int32 CFF_CLEAR_MODE_COLOR_WRITE_ENABLED_OFFSET                              = (16 + CFF_CLEAR_MODE_CLEAR_COLOR_OFFSET);
    static const Int32 CFF_CLEAR_MODE_IS_DEPTH_CLEAR_ENABLED_OFFSET                           = (16 + CFF_CLEAR_MODE_COLOR_WRITE_ENABLED_OFFSET);
    static const Int32 CFF_CLEAR_MODE_CLEAR_DEPTH_OFFSET                                      = (4 + CFF_CLEAR_MODE_IS_DEPTH_CLEAR_ENABLED_OFFSET);
    static const Int32 CFF_CLEAR_MODE_IS_STENCIL_CLEAR_ENABLED_OFFSET                         = (4 + CFF_CLEAR_MODE_CLEAR_DEPTH_OFFSET);
    static const Int32 CFF_CLEAR_MODE_STENCIL_CLEAR_VALUE_OFFSET                              = (4 + CFF_CLEAR_MODE_IS_STENCIL_CLEAR_ENABLED_OFFSET);
    static const Int32 CFF_CLEAR_MODE_STENCIL_WRITE_MASK_OFFSET                               = (4 + CFF_CLEAR_MODE_STENCIL_CLEAR_VALUE_OFFSET);
    static const Int32 CFF_CLEAR_MODE_IS_SKY_BOX_ENABLED_OFFSET                               = (4 + CFF_CLEAR_MODE_STENCIL_WRITE_MASK_OFFSET);
    static const Int32 CFF_CLEAR_MODE_SKY_BOX_OFFSET                                          = (4 + CFF_CLEAR_MODE_IS_SKY_BOX_ENABLED_OFFSET);
    static const Int32 CFF_CLEAR_MODE_SIZE                                                    = (16 + CFF_CLEAR_MODE_SKY_BOX_OFFSET);

    // getter methods for ClearMode
    inline bool GetClearModeIsColorClearEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CLEAR_MODE_IS_COLOR_CLEAR_ENABLED_OFFSET);
    }
    inline void GetClearModeClearColor(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_CLEAR_MODE_CLEAR_COLOR_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_CLEAR_MODE_CLEAR_COLOR_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_CLEAR_MODE_CLEAR_COLOR_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_CLEAR_MODE_CLEAR_COLOR_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline void GetClearModeColorWriteEnabled(const AssetDataHandle& handle, bool& redEnabled, bool& greenEnabled, bool& blueEnabled, bool& alphaEnabled)
    {
        redEnabled = CffGetValSafe<bool>(handle, CFF_CLEAR_MODE_COLOR_WRITE_ENABLED_OFFSET);
        greenEnabled = CffGetValSafe<bool>(handle, CFF_CLEAR_MODE_COLOR_WRITE_ENABLED_OFFSET + (1 * CFF_BOOL_SIZE));
        blueEnabled = CffGetValSafe<bool>(handle, CFF_CLEAR_MODE_COLOR_WRITE_ENABLED_OFFSET + (2 * CFF_BOOL_SIZE));
        alphaEnabled = CffGetValSafe<bool>(handle, CFF_CLEAR_MODE_COLOR_WRITE_ENABLED_OFFSET + (3 * CFF_BOOL_SIZE));
    }
    inline bool GetClearModeIsDepthClearEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CLEAR_MODE_IS_DEPTH_CLEAR_ENABLED_OFFSET);
    }
    inline Float GetClearModeClearDepth(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_CLEAR_MODE_CLEAR_DEPTH_OFFSET);
    }
    inline bool GetClearModeIsStencilClearEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CLEAR_MODE_IS_STENCIL_CLEAR_ENABLED_OFFSET);
    }
    inline Int32 GetClearModeStencilClearValue(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CLEAR_MODE_STENCIL_CLEAR_VALUE_OFFSET);
    }
    inline UInt32 GetClearModeStencilWriteMask(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_CLEAR_MODE_STENCIL_WRITE_MASK_OFFSET);
    }
    inline bool GetClearModeIsSkyBoxEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CLEAR_MODE_IS_SKY_BOX_ENABLED_OFFSET);
    }
    inline const UInt32* GetClearModeSkyBox(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_CLEAR_MODE_SKY_BOX_OFFSET);
    }

}}} //namespaces

#endif //ClearMode_CffReader_H
