//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef CanvasGroup_CffReader_H
#define CanvasGroup_CffReader_H

#include "CanvasNodeCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for CanvasGroup
    static const Int32 CFF_CANVAS_GROUP_IS_LAYOUT_ENABLED_OFFSET                              = (CFF_CANVAS_NODE_SIZE);
    static const Int32 CFF_CANVAS_GROUP_LAYOUT_PTR_OFFSET                                     = (4 + CFF_CANVAS_GROUP_IS_LAYOUT_ENABLED_OFFSET);
    static const Int32 CFF_CANVAS_GROUP_SIZE                                                  = (CFF_PTR_SIZE + CFF_CANVAS_GROUP_LAYOUT_PTR_OFFSET);

    // getter methods for CanvasGroup
    inline bool GetCanvasGroupIsLayoutEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CANVAS_GROUP_IS_LAYOUT_ENABLED_OFFSET);
    }
    inline AssetDataHandle GetCanvasGroupLayout(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_CANVAS_GROUP_LAYOUT_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //CanvasGroup_CffReader_H
