//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef CanderaObject_CffReader_H
#define CanderaObject_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for CanderaObject
    static const Int32 CFF_CANDERA_OBJECT_ITEM_SIZE_OFFSET                                    = (0);
    static const Int32 CFF_CANDERA_OBJECT_ITEM_TYPE_OFFSET                                    = (4 + CFF_CANDERA_OBJECT_ITEM_SIZE_OFFSET);
    static const Int32 CFF_CANDERA_OBJECT_CANDERA_NAME_OFFSET                                 = (4 + CFF_CANDERA_OBJECT_ITEM_TYPE_OFFSET);
    static const Int32 CFF_CANDERA_OBJECT_CANDERA_ID_OFFSET                                   = (4 + CFF_CANDERA_OBJECT_CANDERA_NAME_OFFSET);
    static const Int32 CFF_CANDERA_OBJECT_SIZE                                                = (16 + CFF_CANDERA_OBJECT_CANDERA_ID_OFFSET);

    // getter methods for CanderaObject
    inline Int32 GetCanderaObjectItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CANDERA_OBJECT_ITEM_SIZE_OFFSET);
    }
    inline Int32 GetCanderaObjectItemType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CANDERA_OBJECT_ITEM_TYPE_OFFSET);
    }
    inline Int32 GetCanderaObjectCanderaName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_CANDERA_OBJECT_CANDERA_NAME_OFFSET);
        return nameIndex;
    }
    inline const UInt32* GetCanderaObjectCanderaId(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_CANDERA_OBJECT_CANDERA_ID_OFFSET);
    }

}}} //namespaces

#endif //CanderaObject_CffReader_H
