//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef CameraGroup_CffReader_H
#define CameraGroup_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for CameraGroup
    static const Int32 CFF_CAMERA_GROUP_CAMERAS_LENGTH_OFFSET                                 = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_CAMERA_GROUP_CAMERAS_PTR_OFFSET                                    = (4 + CFF_CAMERA_GROUP_CAMERAS_LENGTH_OFFSET);
    static const Int32 CFF_CAMERA_GROUP_SIZE                                                  = (CFF_PTR_SIZE + CFF_CAMERA_GROUP_CAMERAS_PTR_OFFSET);

    // getter methods for CameraGroup
    inline Int32 GetCameraGroupCamerasLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CAMERA_GROUP_CAMERAS_LENGTH_OFFSET);
    }
    inline const UInt32* const * GetCameraGroupCameras(const AssetDataHandle& handle)
    {
        return CffGetPtr<const UInt32*>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_CAMERA_GROUP_CAMERAS_PTR_OFFSET)), 0);
    }
    inline const UInt32* GetCameraGroupCamerasElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_CAMERA_GROUP_CAMERAS_PTR_OFFSET));
        return CffGetPtrSafe<UInt32>(listHandle, (index * CFF_ITEMID_SIZE));
    }

}}} //namespaces

#endif //CameraGroup_CffReader_H
