//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef BounceFunction_CffReader_H
#define BounceFunction_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for BounceFunction
    static const Int32 CFF_BOUNCE_FUNCTION_ITEM_SIZE_OFFSET                                   = (0);
    static const Int32 CFF_BOUNCE_FUNCTION_RESTITUTION_COEFFICIENT_OFFSET                     = (4 + CFF_BOUNCE_FUNCTION_ITEM_SIZE_OFFSET);
    static const Int32 CFF_BOUNCE_FUNCTION_BOUNCE_COUNT_OFFSET                                = (4 + CFF_BOUNCE_FUNCTION_RESTITUTION_COEFFICIENT_OFFSET);
    static const Int32 CFF_BOUNCE_FUNCTION_SIZE                                               = (4 + CFF_BOUNCE_FUNCTION_BOUNCE_COUNT_OFFSET);

    // getter methods for BounceFunction
    inline Int32 GetBounceFunctionItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BOUNCE_FUNCTION_ITEM_SIZE_OFFSET);
    }
    inline Float GetBounceFunctionRestitutionCoefficient(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_BOUNCE_FUNCTION_RESTITUTION_COEFFICIENT_OFFSET);
    }
    inline UInt8 GetBounceFunctionBounceCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt8>(handle, CFF_BOUNCE_FUNCTION_BOUNCE_COUNT_OFFSET);
    }

}}} //namespaces

#endif //BounceFunction_CffReader_H
