//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Bitmap_CffReader_H
#define Bitmap_CffReader_H

#include "BinaryItemCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Bitmap
    static const Int32 CFF_BITMAP_BITMAP_PIXELS_LENGTH_OFFSET                                 = (CFF_BINARY_ITEM_SIZE);
    static const Int32 CFF_BITMAP_BITMAP_PIXELS_PTR_OFFSET                                    = (4 + CFF_BITMAP_BITMAP_PIXELS_LENGTH_OFFSET);
    static const Int32 CFF_BITMAP_WIDTH_OFFSET                                                = (CFF_PTR_SIZE + CFF_BITMAP_BITMAP_PIXELS_PTR_OFFSET);
    static const Int32 CFF_BITMAP_HEIGHT_OFFSET                                               = (4 + CFF_BITMAP_WIDTH_OFFSET);
    static const Int32 CFF_BITMAP_PIXEL_FORMAT_OFFSET                                         = (4 + CFF_BITMAP_HEIGHT_OFFSET);
    static const Int32 CFF_BITMAP_PACK_ALIGNMENT_OFFSET                                       = (4 + CFF_BITMAP_PIXEL_FORMAT_OFFSET);
    static const Int32 CFF_BITMAP_IS_VERTICALLY_FLIPPED_OFFSET                                = (4 + CFF_BITMAP_PACK_ALIGNMENT_OFFSET);
    static const Int32 CFF_BITMAP_NEXT_BITMAP_PTR_OFFSET                                      = (4 + CFF_BITMAP_IS_VERTICALLY_FLIPPED_OFFSET);
    static const Int32 CFF_BITMAP_IS_MIP_MAPPING_ENABLED_OFFSET                               = (CFF_PTR_SIZE + CFF_BITMAP_NEXT_BITMAP_PTR_OFFSET);
    static const Int32 CFF_BITMAP_MEMORY_POOL_OFFSET                                          = (4 + CFF_BITMAP_IS_MIP_MAPPING_ENABLED_OFFSET);
    static const Int32 CFF_BITMAP_IS_PIVOT_HINT_ENABLED_OFFSET                                = (4 + CFF_BITMAP_MEMORY_POOL_OFFSET);
    static const Int32 CFF_BITMAP_PIVOT_HINT_OFFSET                                           = (4 + CFF_BITMAP_IS_PIVOT_HINT_ENABLED_OFFSET);
    static const Int32 CFF_BITMAP_BITMAP_LAYOUT_OFFSET                                        = (8 + CFF_BITMAP_PIVOT_HINT_OFFSET);
    static const Int32 CFF_BITMAP_NINE_PATCH_STRETCHABLE_AREA_OFFSET                          = (4 + CFF_BITMAP_BITMAP_LAYOUT_OFFSET);
    static const Int32 CFF_BITMAP_SIZE                                                        = (16 + CFF_BITMAP_NINE_PATCH_STRETCHABLE_AREA_OFFSET);

    // getter methods for Bitmap
    inline Int32 GetBitmapBitmapPixelsLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BITMAP_BITMAP_PIXELS_LENGTH_OFFSET);
    }
    inline Int32 GetBitmapBitmapPixelsRegion(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BITMAP_BITMAP_PIXELS_PTR_OFFSET);
    }
    inline UInt16 GetBitmapWidth(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt16>(handle, CFF_BITMAP_WIDTH_OFFSET);
    }
    inline UInt16 GetBitmapHeight(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt16>(handle, CFF_BITMAP_HEIGHT_OFFSET);
    }
    inline Int32 GetBitmapPixelFormat(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BITMAP_PIXEL_FORMAT_OFFSET);
    }
    inline Int32 GetBitmapPackAlignment(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BITMAP_PACK_ALIGNMENT_OFFSET);
    }
    inline bool GetBitmapIsVerticallyFlipped(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_BITMAP_IS_VERTICALLY_FLIPPED_OFFSET);
    }
    inline AssetDataHandle GetBitmapNextBitmap(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_BITMAP_NEXT_BITMAP_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline bool GetBitmapIsMipMappingEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_BITMAP_IS_MIP_MAPPING_ENABLED_OFFSET);
    }
    inline Int32 GetBitmapMemoryPool(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BITMAP_MEMORY_POOL_OFFSET);
    }
    inline bool GetBitmapIsPivotHintEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_BITMAP_IS_PIVOT_HINT_ENABLED_OFFSET);
    }
    inline void GetBitmapPivotHint(const AssetDataHandle& handle, Float& x, Float& y)
    {
        x = CffGetValSafe<Float>(handle, CFF_BITMAP_PIVOT_HINT_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_BITMAP_PIVOT_HINT_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline Int32 GetBitmapBitmapLayout(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BITMAP_BITMAP_LAYOUT_OFFSET);
    }
    inline void GetBitmapNinePatchStretchableArea(const AssetDataHandle& handle, Int32& left, Int32& top, Int32& right, Int32& bottom)
    {
        left = CffGetValSafe<Int32>(handle, CFF_BITMAP_NINE_PATCH_STRETCHABLE_AREA_OFFSET);
        top = CffGetValSafe<Int32>(handle, CFF_BITMAP_NINE_PATCH_STRETCHABLE_AREA_OFFSET + (1 * CFF_INT_SIZE));
        right = CffGetValSafe<Int32>(handle, CFF_BITMAP_NINE_PATCH_STRETCHABLE_AREA_OFFSET + (2 * CFF_INT_SIZE));
        bottom = CffGetValSafe<Int32>(handle, CFF_BITMAP_NINE_PATCH_STRETCHABLE_AREA_OFFSET + (3 * CFF_INT_SIZE));
    }

}}} //namespaces

#endif //Bitmap_CffReader_H
