//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Billboard_CffReader_H
#define Billboard_CffReader_H

#include "Node3DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Billboard
    static const Int32 CFF_BILLBOARD_WIDTH_OFFSET                                             = (CFF_NODE_3D_SIZE);
    static const Int32 CFF_BILLBOARD_HEIGHT_OFFSET                                            = (4 + CFF_BILLBOARD_WIDTH_OFFSET);
    static const Int32 CFF_BILLBOARD_ALIGNMENT_OFFSET                                         = (4 + CFF_BILLBOARD_HEIGHT_OFFSET);
    static const Int32 CFF_BILLBOARD_BOTTOM_LEFT_OFFSET                                       = (4 + CFF_BILLBOARD_ALIGNMENT_OFFSET);
    static const Int32 CFF_BILLBOARD_TOP_LEFT_OFFSET                                          = (8 + CFF_BILLBOARD_BOTTOM_LEFT_OFFSET);
    static const Int32 CFF_BILLBOARD_BOTTOM_RIGHT_OFFSET                                      = (8 + CFF_BILLBOARD_TOP_LEFT_OFFSET);
    static const Int32 CFF_BILLBOARD_TOP_RIGHT_OFFSET                                         = (8 + CFF_BILLBOARD_BOTTOM_RIGHT_OFFSET);
    static const Int32 CFF_BILLBOARD_SIZE                                                     = (8 + CFF_BILLBOARD_TOP_RIGHT_OFFSET);

    // getter methods for Billboard
    inline Float GetBillboardWidth(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_BILLBOARD_WIDTH_OFFSET);
    }
    inline Float GetBillboardHeight(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_BILLBOARD_HEIGHT_OFFSET);
    }
    inline Int32 GetBillboardAlignment(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BILLBOARD_ALIGNMENT_OFFSET);
    }
    inline void GetBillboardBottomLeft(const AssetDataHandle& handle, Float& u, Float& v)
    {
        u = CffGetValSafe<Float>(handle, CFF_BILLBOARD_BOTTOM_LEFT_OFFSET);
        v = CffGetValSafe<Float>(handle, CFF_BILLBOARD_BOTTOM_LEFT_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline void GetBillboardTopLeft(const AssetDataHandle& handle, Float& u, Float& v)
    {
        u = CffGetValSafe<Float>(handle, CFF_BILLBOARD_TOP_LEFT_OFFSET);
        v = CffGetValSafe<Float>(handle, CFF_BILLBOARD_TOP_LEFT_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline void GetBillboardBottomRight(const AssetDataHandle& handle, Float& u, Float& v)
    {
        u = CffGetValSafe<Float>(handle, CFF_BILLBOARD_BOTTOM_RIGHT_OFFSET);
        v = CffGetValSafe<Float>(handle, CFF_BILLBOARD_BOTTOM_RIGHT_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline void GetBillboardTopRight(const AssetDataHandle& handle, Float& u, Float& v)
    {
        u = CffGetValSafe<Float>(handle, CFF_BILLBOARD_TOP_RIGHT_OFFSET);
        v = CffGetValSafe<Float>(handle, CFF_BILLBOARD_TOP_RIGHT_OFFSET + (1 * CFF_FLOAT_SIZE));
    }

}}} //namespaces

#endif //Billboard_CffReader_H
