//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef BezierInterpolation_CffReader_H
#define BezierInterpolation_CffReader_H

#include "BaseAnimationInterpolationCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for BezierInterpolation
    static const Int32 CFF_BEZIER_INTERPOLATION_CONTROL_POINTS_PTR_OFFSET                     = (CFF_BASE_ANIMATION_INTERPOLATION_SIZE);
    static const Int32 CFF_BEZIER_INTERPOLATION_DIRECTION_DUMMY_OFFSET                        = (CFF_PTR_SIZE + CFF_BEZIER_INTERPOLATION_CONTROL_POINTS_PTR_OFFSET);
    static const Int32 CFF_BEZIER_INTERPOLATION_FUNCTION_DUMMY_OFFSET                         = (4 + CFF_BEZIER_INTERPOLATION_DIRECTION_DUMMY_OFFSET);
    static const Int32 CFF_BEZIER_INTERPOLATION_INTERPOLATION_FUNCTION_DUMMY_OFFSET           = (4 + CFF_BEZIER_INTERPOLATION_FUNCTION_DUMMY_OFFSET);
    static const Int32 CFF_BEZIER_INTERPOLATION_SIZE                                          = (4 + CFF_BEZIER_INTERPOLATION_INTERPOLATION_FUNCTION_DUMMY_OFFSET);

    // getter methods for BezierInterpolation
    inline Int32 GetBezierInterpolationControlPointsDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_BEZIER_INTERPOLATION_CONTROL_POINTS_PTR_OFFSET)); 
    }
    inline Int32 GetBezierInterpolationControlPointsCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_BEZIER_INTERPOLATION_CONTROL_POINTS_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetBezierInterpolationControlPointsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_BEZIER_INTERPOLATION_CONTROL_POINTS_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }
    inline Int32 GetBezierInterpolationDirectionDummy(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BEZIER_INTERPOLATION_DIRECTION_DUMMY_OFFSET);
    }
    inline Int32 GetBezierInterpolationFunctionDummy(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BEZIER_INTERPOLATION_FUNCTION_DUMMY_OFFSET);
    }
    inline Int32 GetBezierInterpolationInterpolationFunctionDummy(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BEZIER_INTERPOLATION_INTERPOLATION_FUNCTION_DUMMY_OFFSET);
    }

}}} //namespaces

#endif //BezierInterpolation_CffReader_H
