//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef BaseState_CffReader_H
#define BaseState_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for BaseState
    static const Int32 CFF_BASE_STATE_STATE_NAME_OFFSET                                       = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_BASE_STATE_STATE_TYPE_OFFSET                                       = (4 + CFF_BASE_STATE_STATE_NAME_OFFSET);
    static const Int32 CFF_BASE_STATE_NO_ENTRY_ACTIONS_OFFSET                                 = (4 + CFF_BASE_STATE_STATE_TYPE_OFFSET);
    static const Int32 CFF_BASE_STATE_NO_EXIT_ACTIONS_OFFSET                                  = (4 + CFF_BASE_STATE_NO_ENTRY_ACTIONS_OFFSET);
    static const Int32 CFF_BASE_STATE_NO_SUB_STATES_OFFSET                                    = (4 + CFF_BASE_STATE_NO_EXIT_ACTIONS_OFFSET);
    static const Int32 CFF_BASE_STATE_NO_TRANSITIONS_OFFSET                                   = (4 + CFF_BASE_STATE_NO_SUB_STATES_OFFSET);
    static const Int32 CFF_BASE_STATE_SIZE                                                    = (4 + CFF_BASE_STATE_NO_TRANSITIONS_OFFSET);

    // getter methods for BaseState
    inline Int32 GetBaseStateStateName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_BASE_STATE_STATE_NAME_OFFSET);
        return nameIndex;
    }
    inline Int32 GetBaseStateStateType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BASE_STATE_STATE_TYPE_OFFSET);
    }
    inline Int32 GetBaseStateNoEntryActions(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BASE_STATE_NO_ENTRY_ACTIONS_OFFSET);
    }
    inline Int32 GetBaseStateNoExitActions(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BASE_STATE_NO_EXIT_ACTIONS_OFFSET);
    }
    inline Int32 GetBaseStateNoSubStates(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BASE_STATE_NO_SUB_STATES_OFFSET);
    }
    inline Int32 GetBaseStateNoTransitions(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BASE_STATE_NO_TRANSITIONS_OFFSET);
    }

}}} //namespaces

#endif //BaseState_CffReader_H
