//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef BaseAnimationInterpolation_CffReader_H
#define BaseAnimationInterpolation_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for BaseAnimationInterpolation
    static const Int32 CFF_BASE_ANIMATION_INTERPOLATION_KEYFRAMES_PTR_OFFSET                  = (0);
    static const Int32 CFF_BASE_ANIMATION_INTERPOLATION_SIZE                                  = (CFF_PTR_SIZE + CFF_BASE_ANIMATION_INTERPOLATION_KEYFRAMES_PTR_OFFSET);

    // getter methods for BaseAnimationInterpolation
    inline Int32 GetBaseAnimationInterpolationKeyframesDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_BASE_ANIMATION_INTERPOLATION_KEYFRAMES_PTR_OFFSET)); 
    }
    inline Int32 GetBaseAnimationInterpolationKeyframesCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_BASE_ANIMATION_INTERPOLATION_KEYFRAMES_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetBaseAnimationInterpolationKeyframesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_BASE_ANIMATION_INTERPOLATION_KEYFRAMES_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }

}}} //namespaces

#endif //BaseAnimationInterpolation_CffReader_H
