//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef AnimationNodeBase_CffReader_H
#define AnimationNodeBase_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for AnimationNodeBase
    static const Int32 CFF_ANIMATION_NODE_BASE_DELAY_OFFSET                                   = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_ANIMATION_NODE_BASE_START_TYPE_OFFSET                              = (4 + CFF_ANIMATION_NODE_BASE_DELAY_OFFSET);
    static const Int32 CFF_ANIMATION_NODE_BASE_PREVIOUS_OFFSET                                = (4 + CFF_ANIMATION_NODE_BASE_START_TYPE_OFFSET);
    static const Int32 CFF_ANIMATION_NODE_BASE_SIZE                                           = (16 + CFF_ANIMATION_NODE_BASE_PREVIOUS_OFFSET);

    // getter methods for AnimationNodeBase
    inline UInt32 GetAnimationNodeBaseDelay(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ANIMATION_NODE_BASE_DELAY_OFFSET);
    }
    inline Int32 GetAnimationNodeBaseStartType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANIMATION_NODE_BASE_START_TYPE_OFFSET);
    }
    inline const UInt32* GetAnimationNodeBasePrevious(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_ANIMATION_NODE_BASE_PREVIOUS_OFFSET);
    }

}}} //namespaces

#endif //AnimationNodeBase_CffReader_H
