//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef AnimatedProperty_CffReader_H
#define AnimatedProperty_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for AnimatedProperty
    static const Int32 CFF_ANIMATED_PROPERTY_ITEM_SIZE_OFFSET                                 = (0);
    static const Int32 CFF_ANIMATED_PROPERTY_ITEM_TYPE_OFFSET                                 = (4 + CFF_ANIMATED_PROPERTY_ITEM_SIZE_OFFSET);
    static const Int32 CFF_ANIMATED_PROPERTY_PROPERTY_NAME_OFFSET                             = (4 + CFF_ANIMATED_PROPERTY_ITEM_TYPE_OFFSET);
    static const Int32 CFF_ANIMATED_PROPERTY_HOST_ITEM_PROPERTY_ID_OFFSET                     = (4 + CFF_ANIMATED_PROPERTY_PROPERTY_NAME_OFFSET);
    static const Int32 CFF_ANIMATED_PROPERTY_ANIMATED_PROPERTY_TYPE_OFFSET                    = (4 + CFF_ANIMATED_PROPERTY_HOST_ITEM_PROPERTY_ID_OFFSET);
    static const Int32 CFF_ANIMATED_PROPERTY_CHANNELS_PTR_OFFSET                              = (4 + CFF_ANIMATED_PROPERTY_ANIMATED_PROPERTY_TYPE_OFFSET);
    static const Int32 CFF_ANIMATED_PROPERTY_TRANSFORMABLE_OFFSET                             = (CFF_PTR_SIZE + CFF_ANIMATED_PROPERTY_CHANNELS_PTR_OFFSET);
    static const Int32 CFF_ANIMATED_PROPERTY_INTERPOLATION_PTR_OFFSET                         = (16 + CFF_ANIMATED_PROPERTY_TRANSFORMABLE_OFFSET);
    static const Int32 CFF_ANIMATED_PROPERTY_SIZE                                             = (CFF_PTR_SIZE + CFF_ANIMATED_PROPERTY_INTERPOLATION_PTR_OFFSET);

    // getter methods for AnimatedProperty
    inline Int32 GetAnimatedPropertyItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANIMATED_PROPERTY_ITEM_SIZE_OFFSET);
    }
    inline Int32 GetAnimatedPropertyItemType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANIMATED_PROPERTY_ITEM_TYPE_OFFSET);
    }
    inline Int32 GetAnimatedPropertyPropertyName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_ANIMATED_PROPERTY_PROPERTY_NAME_OFFSET);
        return nameIndex;
    }
    inline Int32 GetAnimatedPropertyHostItemPropertyId(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANIMATED_PROPERTY_HOST_ITEM_PROPERTY_ID_OFFSET);
    }
    inline Int32 GetAnimatedPropertyAnimatedPropertyType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANIMATED_PROPERTY_ANIMATED_PROPERTY_TYPE_OFFSET);
    }
    inline Int32 GetAnimatedPropertyChannelsDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_ANIMATED_PROPERTY_CHANNELS_PTR_OFFSET)); 
    }
    inline Int32 GetAnimatedPropertyChannelsCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_ANIMATED_PROPERTY_CHANNELS_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline Int32 const * GetAnimatedPropertyChannels(const AssetDataHandle& handle)
    {
        return CffGetPtr<Int32>(CffGetHandle(CffGetAssetLibHandle(handle), CFF_INT_SIZE + CFF_INT_SIZE + CffGetValSafe<Int32>(handle, CFF_ANIMATED_PROPERTY_CHANNELS_PTR_OFFSET)), 0);
    }
    inline Int32 GetAnimatedPropertyChannelsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_ANIMATED_PROPERTY_CHANNELS_PTR_OFFSET));
        return CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_INT_SIZE));
    }
    inline const UInt32* GetAnimatedPropertyTransformable(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_ANIMATED_PROPERTY_TRANSFORMABLE_OFFSET);
    }
    inline AssetDataHandle GetAnimatedPropertyInterpolation(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_ANIMATED_PROPERTY_INTERPOLATION_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //AnimatedProperty_CffReader_H
