//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AssetProviderDispatcher.h"

#include <Candera/System/Diagnostics/Log.h>

namespace Candera {

    using namespace Diagnostics;
    using namespace Internal;

    ThreadedAssetProviderDispatcher::ThreadedAssetProviderDispatcher():
        m_dispatcher(1)
    {
        m_init = Init();
    }

    ThreadedAssetProviderDispatcher::~ThreadedAssetProviderDispatcher()
    {
        FEATSTD_LINT_IGNORE_RETURN_VALUE(m_dispatcher.Stop());
    }

    bool ThreadedAssetProviderDispatcher::Init()
    {
        return m_dispatcher.Start();
    }

    FeatStd::AsyncRequestDispatcher& ThreadedAssetProviderDispatcher::GetRequestDispatcher()
    {
        if (!m_init) {
            m_init = Init();
        }
        return m_dispatcher.GetDispatcher();
    }

    FeatStd::AsyncRequestDispatcher& AsyncAssetProviderDispatcher::GetRequestDispatcher()
    {
        return m_dispatcher;
    }
    
    AsyncAssetProviderDispatcher::AsyncAssetProviderDispatcher():
        m_dispatcher(false)
    {

    }

    AsyncAssetProviderDispatcher::~AsyncAssetProviderDispatcher()
    {
        FEATSTD_LINT_IGNORE_RETURN_VALUE(m_dispatcher.Flush());
    }
    
}
