//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CanderaAssetLoader_AssetLoaderBase_AssetLoaderMemoryPool_h)
    #define CanderaAssetLoader_AssetLoaderBase_AssetLoaderMemoryPool_h

#include <Candera/Environment.h>

#if defined(FEATSTD_ENABLE_MEMORYPOOL_ALLOCATIONS)
    #include <FeatStd/MemoryPool/MemoryPool.h>
#else
    #include <FeatStd/MemoryManagement/Heap.h>
#endif

#include <FeatStd/MemoryManagement/Allocator.h>

namespace Candera {

    /** @addtogroup AssetLoaderBase
     *  @{
     */

#if defined(FEATSTD_ENABLE_MEMORYPOOL_ALLOCATIONS)

    /// Transient alloc for asset loader allocations
    #define ASSETLOADER_TRANSIENT_ALLOC(nBytes) \
        FEATSTD_MEMORYPOOL_ALLOC(Candera::AssetLoaderMemoryPool, FeatStd::UInt8(FeatStd::MemoryManagement::MemAttrib::Transient), (nBytes))

    /// Permanent alloc for asset loader allocations
    #define ASSETLOADER_PERMANENT_ALLOC(nBytes) \
        FEATSTD_MEMORYPOOL_ALLOC(Candera::AssetLoaderMemoryPool, FeatStd::UInt8(FeatStd::MemoryManagement::MemAttrib::Permanent), (nBytes))

    /// Realloc for asset loader allocations
    #define ASSETLOADER_REALLOC(buffer, newSize) \
        FEATSTD_MEMORYPOOL_REALLOC(Candera::AssetLoaderMemoryPool, buffer, newSize)

    /// free for asset loader allocations
    #define ASSETLOADER_FREE(buffer) \
        FEATSTD_MEMORYPOOL_FREE(Candera::AssetLoaderMemoryPool, buffer)

    /// Transient new for asset loader allocations
    #define ASSETLOADER_TRANSIENT_NEW(type) \
        FEATSTD_MEMORYPOOL_TRANSIENT_NEW(Candera::AssetLoaderMemoryPool, type)

    /// Transient new[] for asset loader allocations
    #define ASSETLOADER_TRANSIENT_NEW_ARRAY(type, count) \
        FEATSTD_MEMORYPOOL_ARRAY_NEW(Candera::AssetLoaderMemoryPool, FeatStd::MemoryManagement::MemAttrib::Transient, type, (count))

    /// Permanent new for asset loader allocations
    #define ASSETLOADER_PERMANENT_NEW(type) \
        FEATSTD_MEMORYPOOL_PERMANENT_NEW(Candera::AssetLoaderMemoryPool, type)

    /// Permanent new[] for asset loader allocations
    #define ASSETLOADER_PERMANENT_NEW_ARRAY(type, count) \
        FEATSTD_MEMORYPOOL_ARRAY_NEW(Candera::AssetLoaderMemoryPool, FeatStd::MemoryManagement::MemAttrib::Permanent, type, (count))

    /// delete for asset loader allocations
    #define ASSETLOADER_DELETE(p)       FEATSTD_MEMORYPOOL_DELETE(p)

    /// delete[] for asset loader allocations
    #define ASSETLOADER_DELETE_ARRAY(p) FEATSTD_MEMORYPOOL_ARRAY_DELETE(p)

    #if defined(CANDERA_ASSETLOADER_MEMORYPOOL_ENABLED)
        /// Define a dedicated memory pool for asset loader allocations.
        extern bool InitAssetLoaderMemoryPool();
        FEATSTD_MEMORYPOOL_DEFINE_MANAGED_MEMORYPOOL(AssetLoaderMemoryPool, InitAssetLoaderMemoryPool);
    #else
        /// use the default memory pool
        typedef FeatStd::DefaultMemoryPool AssetLoaderMemoryPool;
    #endif

    #define ASSETLOADER_TRANSIENT_ALLOCATOR \
        FeatStd::MemoryManagement::Allocator<AssetLoaderMemoryPool, FeatStd::MemoryManagement::MemAttrib::Transient>

    #define ASSETLOADER_PERMANENT_ALLOCATOR \
        FeatStd::MemoryManagement::Allocator<AssetLoaderMemoryPool, FeatStd::MemoryManagement::MemAttrib::Permanent>

#else
    /// Transient alloc for asset loader allocations
    #define ASSETLOADER_TRANSIENT_ALLOC(nBytes)             FEATSTD_ALLOC(nBytes)

    /// Permanent alloc for asset loader allocations
    #define ASSETLOADER_PERMANENT_ALLOC(nBytes)             FEATSTD_ALLOC(nBytes)

    /// Realloc for asset loader allocations
    #define ASSETLOADER_REALLOC(buffer, nBytes)             FEATSTD_REALLOC(buffer, nBytes)

    /// free for asset loader allocations
    #define ASSETLOADER_FREE(buffer)                        FEATSTD_FREE(buffer)

    /// Transient new for asset loader allocations
    #define ASSETLOADER_TRANSIENT_NEW(type)                 FEATSTD_NEW(type)

    /// Transient new[] for asset loader allocations
    #define ASSETLOADER_TRANSIENT_NEW_ARRAY(type, count)    FEATSTD_NEW_ARRAY(type, (count))

    /// Permanent new
    #define ASSETLOADER_PERMANENT_NEW(type)                 FEATSTD_NEW(type)

    /// Permanent new[] for asset loader allocations
    #define ASSETLOADER_PERMANENT_NEW_ARRAY(type, count)    FEATSTD_NEW_ARRAY(type, (count))

    /// delete for asset loader allocations
    #define ASSETLOADER_DELETE(p)                           FEATSTD_DELETE(p)

    /// delete[] for asset loader allocations
    #define ASSETLOADER_DELETE_ARRAY(p)                     FEATSTD_DELETE_ARRAY(p)

    #define ASSETLOADER_TRANSIENT_ALLOCATOR \
        FeatStd::MemoryManagement::DefaultAllocator

    #define ASSETLOADER_PERMANENT_ALLOCATOR \
        FeatStd::MemoryManagement::DefaultAllocator

#endif

    /** @} */ // end of AssetLoaderBase
}

#endif // CanderaAssetLoader_AssetLoaderBase_AssetLoaderMemoryPool_h
