//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AssetLoaderBaseDataTypes.h"

#include <Candera/EngineBase/DataTypes/CanderaObjectDataType.h>
#include <Candera/EngineBase/Common/Bitmap.h>
#include <Candera/TextEngine/Style.h>
#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnit.h>
#include <CanderaPlatform/Device/Common/Base/ImageSource2D.h>
#include <CanderaPlatform/Device/Common/Base/ImageSource3D.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderDataType.h>
#include <CanderaAssetLoader/AssetLoaderBase/AnimationPlayerDataType.h>
#include <Candera/EngineBase/Animation/AnimationGroupPlayer.h>
#include <Candera/EngineBase/Animation/AnimationPlayer.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderDataTypeTemplate.h>
#include <Candera/EngineBase/DataTypes/ColorDataType.h>
#include <CanderaBehavior/BehaviorBase/Behavior.h>

namespace Candera {
    namespace MetaInfo {
        FEATSTD_LINT_SYMBOL(753, Candera::MetaInfo::CanderaObjectDataTypeCast<*>, "Violates MISRA C++ 2008 Required Rule 0-1-5: false positive, used in macro")
        template <> struct CanderaObjectDataTypeCast<ImageSource3D*, GraphicDeviceUnit*> { static ImageSource3D* Cast(GraphicDeviceUnit* gdu) { return gdu->ToImageSource3D();} };
        template <> struct CanderaObjectDataTypeCast<ImageSource2D*, GraphicDeviceUnit*> { static ImageSource2D* Cast(GraphicDeviceUnit* gdu) { return gdu->ToImageSource2D();} };
        template <> struct CanderaObjectDataTypeCast<RenderTarget3D*, GraphicDeviceUnit*> { static RenderTarget3D* Cast(GraphicDeviceUnit* gdu) { return gdu->ToRenderTarget3D();} };
        template <> struct CanderaObjectDataTypeCast<RenderTarget2D*, GraphicDeviceUnit*> { static RenderTarget2D* Cast(GraphicDeviceUnit* gdu) { return gdu->ToRenderTarget2D(); } };
        template <> struct CanderaObjectDataTypeCast<Behavior*, WidgetBase*> { static Behavior* Cast(WidgetBase* widget) { return Dynamic_Cast<Behavior*>(widget); } };

        namespace Internal {
            AssetLoaderDataTypeDecl(TextRendering::SharedStyle::SharedPointer, &AssetProvider::GetTextStyleByAssetId)
            AssetLoaderDataTypeDecl(Bitmap::SharedPointer, &AssetProvider::GetBitmapByAssetId)
            AssetLoaderDataTypeDecl(WidgetBase*, &AssetProvider::GetWidgetByAssetId)
            AssetLoaderDataTypeDecl(CameraGroup*, &AssetProvider::GetCameraGroupByAssetId)
            AssetLoaderDataTypeDecl(GraphicDeviceUnit*, &AssetProvider::GetGraphicDeviceUnitByAssetId)
            AssetLoaderDataTypeDecl(Animation::AnimationPlayerBase::SharedPointer, &AssetProvider::GetAnimationByAssetId)
            AssetLoaderDataTypeDecl(SharedClearMode::SharedPointer, &AssetProvider::GetClearModeByAssetId)
            AssetLoaderDataTypeDecl(Candera::Internal::StateMachineBehaviorData*, &AssetProvider::GetStateMachineBehaviorDataByAssetId)

            CanderaObjectInheritedDataTypeDecl(Animation::AnimationPlayer::SharedPointer, Animation::AnimationPlayerBase::SharedPointer)
            CanderaObjectInheritedDataTypeDecl(Animation::AnimationGroupPlayer::SharedPointer, Animation::AnimationPlayerBase::SharedPointer)

            CanderaObjectInheritedDataTypeDecl(ImageSource3D*, GraphicDeviceUnit*)
            CanderaObjectInheritedDataTypeDecl(ImageSource2D*, GraphicDeviceUnit*)
            CanderaObjectInheritedDataTypeDecl(RenderTarget3D*, GraphicDeviceUnit*)
            CanderaObjectInheritedDataTypeDecl(RenderTarget2D*, GraphicDeviceUnit*)
            CanderaObjectInheritedDataTypeDecl(Behavior*, WidgetBase*)

            bool DataType<Candera::SharedClearMode2D::SharedPointer>::ConvertToString(const SharedClearMode2D::SharedPointer &clearMode, Char *buf, UInt bufLen)
            {
                buf[0] = '\0';
                return (clearMode != 0) ? DataType<Color>::ConvertToString(clearMode->GetClearColor(), buf, bufLen) : true;
            }

            bool DataType<Candera::SharedClearMode2D::SharedPointer>::ConvertFromString(SharedClearMode2D::SharedPointer &clearMode, const Char *buf)
            {
                clearMode = SharedClearMode2D::Create();
                if (!DataType<Color>::ConvertFromString(clearMode->GetClearColor(), buf)) {
                    clearMode.Release();
                    return false;
                }

                return true;
            }

        }
    }
}

