//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if  !defined(CANDERA_ASSETIDITERATOR_H)
#define CANDERA_ASSETIDITERATOR_H

#include <Candera/Environment.h>

#include <CanderaAssetLoader/AssetLoaderBase/AssetGroup.h>

namespace Candera {

    namespace Internal {

        class InternalAssetIdIterator {
        public:
            typedef Id ValueType;
            typedef Id PointerType;
            typedef Id ReferenceType;

            bool operator==(const InternalAssetIdIterator& other) const;
            bool operator!=(const InternalAssetIdIterator& other) const { return !(*this == other); }

            void operator++();
            Id operator*() const;
            InternalAssetIdIterator();
            InternalAssetIdIterator(AssetLib assetLibType, const AssetGroup::AssetSetIterator& assetSetIterator);
        private:
            AssetGroup::AssetSetIterator m_assetSetIterator;
            AssetDataHandle m_assetDataHandle;
            Int32 m_index;
            AssetLib m_assetLibType;
        };

        class InternalRenderTargetIdIterator {
        public:
            typedef Id ValueType;
            typedef Id PointerType;
            typedef Id ReferenceType;

            bool operator==(const InternalRenderTargetIdIterator& other) const;
            bool operator!=(const InternalRenderTargetIdIterator& other) const { return !(*this == other); }

            void operator++();
            Id operator*() const;
            InternalRenderTargetIdIterator(): m_assetDataHandle(), m_index(0) {}
            InternalRenderTargetIdIterator(const AssetDataHandle& assetDataHandle);
        private:
            AssetDataHandle m_assetDataHandle;
            Int32 m_index;
        };
    }

}

#endif //CANDERA_ASSETIDITERATOR_H
