//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AssetIdIterator.h"

#include <CanderaAssetLoader/AssetLoaderBase/CffReader/DevicePackageCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/LibraryHeaderCffReader.h>

namespace Candera { namespace Internal {

    InternalAssetIdIterator::InternalAssetIdIterator(AssetLib assetLibType, const AssetGroup::AssetSetIterator& assetSetIterator)
        :m_assetSetIterator(assetSetIterator),
        m_assetDataHandle(),
        m_index(0), 
        m_assetLibType(assetLibType)
    {
        if (m_assetSetIterator.IsValid()) {
            m_assetDataHandle = AssetDataHandle((*m_assetSetIterator)->GetAssetLibHeaderHandle(m_assetLibType));
            bool isValid = (m_assetDataHandle.IsValid()) && (CFFReader::GetLibElementCount(m_assetDataHandle) > 0);
            while (m_assetSetIterator.IsValid() && (!isValid)) {
                m_index = 0;
                ++m_assetSetIterator;
                if (m_assetSetIterator.IsValid()) {
                    m_assetDataHandle = AssetDataHandle((*m_assetSetIterator)->GetAssetLibHeaderHandle(m_assetLibType));;
                    isValid = (m_assetDataHandle.IsValid()) && (CFFReader::GetLibElementCount(m_assetDataHandle) > 0);
                }
            }
        }
    }

    InternalAssetIdIterator::InternalAssetIdIterator()
        :m_assetSetIterator(), 
        m_assetDataHandle(), 
        m_index(0), 
        m_assetLibType(c_libCount) 
    {
    }

    void InternalAssetIdIterator::operator++()
    {
        ++m_index;
        bool isValid = (m_index < CFFReader::GetLibElementCount(m_assetDataHandle));
        while (m_assetSetIterator.IsValid() && (!isValid)) {
            m_index = 0;
            ++m_assetSetIterator;
            if (m_assetSetIterator.IsValid()) {
                m_assetDataHandle = AssetDataHandle((*m_assetSetIterator)->GetAssetLibHeaderHandle(m_assetLibType));
                isValid = (m_assetDataHandle.IsValid()) && (CFFReader::GetLibElementCount(m_assetDataHandle) > 0);
            }
        }
    }

    bool InternalAssetIdIterator::operator==(const InternalAssetIdIterator& other) const
    { 
        return (this->m_assetSetIterator == other.m_assetSetIterator) && 
            (this->m_assetLibType == other.m_assetLibType) &&
            (this->m_index == other.m_index);
    }

    Id InternalAssetIdIterator::operator*() const
    { 
        return AssetIdFunctions::GetLibraryId(AssetIdFunctions::GetAssetId(CFFReader::GetLibElementId(CFFReader::GetLibElement(m_assetDataHandle, m_index))));
    }

    InternalRenderTargetIdIterator::InternalRenderTargetIdIterator(const AssetDataHandle& assetDataHandle) 
        :m_assetDataHandle(assetDataHandle),
        m_index(0)
    {
        if (m_assetDataHandle.IsValid()) {
            if (CFFReader::GetDevicePackageUserRenderTargetsLength(m_assetDataHandle) == 0) {
                m_assetDataHandle = AssetDataHandle();
            }
        }
    }

    void InternalRenderTargetIdIterator::operator++()
    {
        if (m_assetDataHandle.IsValid()) {
            if (m_index < (CFFReader::GetDevicePackageUserRenderTargetsLength(m_assetDataHandle) - 1)) {
                ++m_index;
            }
            else {
                *this = InternalRenderTargetIdIterator(); 
            }
        }
    }

    bool InternalRenderTargetIdIterator::operator==(const InternalRenderTargetIdIterator& other) const
    { 
        return (this->m_assetDataHandle == other.m_assetDataHandle) && (this->m_index == other.m_index);
    }

    Id InternalRenderTargetIdIterator::operator*() const
    {
        if (m_assetDataHandle.IsValid() && (m_index < CFFReader::GetDevicePackageUserRenderTargetsLength(m_assetDataHandle))) {
            return AssetIdFunctions::GetLibraryId(AssetIdFunctions::GetAssetId(CFFReader::GetDevicePackageUserRenderTargetsElementAt(m_assetDataHandle, m_index)));
        }

        return 0;
    }

}}
