//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_AssetGroup_H)
#define CANDERA_AssetGroup_H

#include <Candera/Environment.h>
#include <Candera/System/Container/SingleLinkedList.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLibHeadInformation.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderMemoryPool.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetDataHandle.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetConfig.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLibEntities.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetSet.h>
#include <Candera/System/MemoryManagement/SharedPointer.h>
#include <Candera/System/Container/ForwardIterator.h>
#include <Candera/EngineBase/Common/ResourceObject.h>

namespace Candera {

    class AssetDescriptor;
    class DefaultAssetProvider;
    namespace Internal {

        class AssetGroup {
            friend class Candera::AssetConfig;
            friend class Candera::AssetDescriptor;

            typedef SingleLinkedList<FeatStd::MemoryManagement::SharedPointer<AssetSet>, ASSETLOADER_TRANSIENT_ALLOCATOR> AssetSetList;
            AssetSetList m_assetSetList;

            public:
            typedef FeatStd::MemoryManagement::SharedPointer<AssetGroup> SharedPointer;

            ~AssetGroup();
            static SharedPointer Create();
            bool Initialize(AssetConfig& assetConfig, UInt32 validationFlags);

            AssetDataHandle GetItemDataHandle(const AssetId& id, UInt16* repositoryId);
            ResourceDataHandle GetItemHeaderHandle(const AssetId& id);
            AssetDataHandle GetLibItemHeader(const AssetId& id);

            ResourceDataHandle GetDefaultRenderModeHandle() const;
            ResourceDataHandle GetAutoUniformsSemanticsHandle() const;
            ResourceDataHandle GetShaderAttributesSemanticsHandle() const;
            ResourceDataHandle GetDevicePackageMetaInfoHandle() const;
            ResourceDataHandle GetTransitionRuleCollectionHandle() const;

            AssetData& GetAssetData() { return m_assetData; }

            typedef ForwardIterator<AssetSetList::Iterator> AssetSetIterator;
            AssetSetIterator GetAssetSetIterator();
            AssetSet* GetAssetSet(UInt16 id);
            bool InitializeAssetVersionInfo(AssetData::AssetVersionInfo& versionInfo) const;

            ResourceDataHandle GetAssetHeaderHandle() const;
        
        private:   
            ResourceDataHandle GetHeaderDataHandle(UInt32(*fn)(const AssetDataHandle&), Int32 size) const;
            FeatStd::MemoryManagement::SharedPointer<AssetSet> AddAssetRepository(AssetRepository* assetRepository);

            AssetData m_assetData;
            UInt32 m_validationFlags;

            AssetGroup();

            class AssetGroupAssetConfigListener: public AssetConfigListener
            {
                public:
                    AssetGroupAssetConfigListener(AssetGroup& assetGroup);
                    ~AssetGroupAssetConfigListener();
                    virtual void OnAssetRepositoryAdded(AssetRepository* assetRepository) override;
                    virtual void OnAssetRepositoryRemoved(AssetRepository* assetRepository) override;
                    virtual void OnAssetConfigDestroy(AssetConfig* assetConfig) override;

                    void SetContainer(AssetConfig* config) {m_container = config; }
                private:
                    FEATSTD_MAKE_CLASS_UNCOPYABLE(AssetGroupAssetConfigListener);
                    AssetGroup& m_assetGroup;
                    AssetConfig* m_container;
            };
            AssetGroupAssetConfigListener m_assetConfigListener;

            // called by AssetConfig
            void OnAssetRepositoryAdded(AssetRepository* assetRepository);
            void OnAssetRepositoryRemoved(const AssetRepository* assetRepository);

            CANDERA_SHARED_POINTER_DECLARATION();
            FEATSTD_MAKE_CLASS_UNCOPYABLE(AssetGroup);
        };

    }   // namespace Internal
}   // namespace Candera

#endif // CANDERA_AssetGroup_H
