//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AssetConfig.h"

namespace Candera {

    class AssetConfig::OnAssetRepositoryAddedEvent : public AssetConfig::ListenerContainer::Event
    {
    public:
        OnAssetRepositoryAddedEvent(AssetRepository* assetRepository) : m_assetRepository(assetRepository) {}
        virtual void Notify(AssetConfigListener* listener) override
        {
            listener->OnAssetRepositoryAdded(m_assetRepository);
        }
    private:
        AssetRepository* m_assetRepository;
    };

    class AssetConfig::OnAssetRepositoryRemovedEvent : public AssetConfig::ListenerContainer::Event
    {
    public:
        OnAssetRepositoryRemovedEvent(AssetRepository* assetRepository) : m_assetRepository(assetRepository) {}
        virtual void Notify(AssetConfigListener* listener) override
        {
            listener->OnAssetRepositoryRemoved(m_assetRepository);
        }
    private:
        AssetRepository* m_assetRepository;
    };

    class AssetConfig::OnAssetConfigDestroyEvent: public AssetConfig::ListenerContainer::Event
    {
    public:
        OnAssetConfigDestroyEvent(AssetConfig* assetConfig): m_assetConfig(assetConfig)
        {
        }
        virtual void Notify(AssetConfigListener* listener) override
        {
            listener->OnAssetConfigDestroy(m_assetConfig);
        }
    private:
        AssetConfig* m_assetConfig;
    };

     /******************************************************************************
      *  OnAssetRepositoryAdded
      ******************************************************************************/
     void AssetConfig::OnAssetRepositoryAdded(AssetRepository* assetRepository)
     {
         OnAssetRepositoryAddedEvent event(assetRepository);
         m_listenerContainer.Iterate(event);
     }

     /******************************************************************************
      *  OnAssetRepositoryRemoved
      ******************************************************************************/
     void AssetConfig::OnAssetRepositoryRemoved(AssetRepository* assetRepository)
     {
         OnAssetRepositoryRemovedEvent event(assetRepository);
         m_listenerContainer.Iterate(event);
     }

    /******************************************************************************
     *  AddAssetConfigListener
     ******************************************************************************/
    bool AssetConfig::AddAssetConfigListener(AssetConfigListener* listener)
    {
        if (listener != 0) {
            return m_listenerContainer.Add(listener);
        }
        return false;
    }

    AssetConfig::~AssetConfig()
    {
        OnAssetConfigDestroyEvent event(this);
        m_listenerContainer.Iterate(event);
    }


    /******************************************************************************
     *  RemoveAssetConfigListener
     ******************************************************************************/
    bool AssetConfig::RemoveAssetConfigListener(AssetConfigListener* listener)
    {
        return m_listenerContainer.Remove(listener);
    }

}   // namespace Candera
