//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_WIDGETBASE_BUILDER_H)
#define CANDERA_WIDGETBASE_BUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {
    class WidgetBase;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::WidgetBase, CffLoaderType, void);

        template<>
        class AssetReaderBase<WidgetBase>: public GenericAssetReaderBase<WidgetBase> {
        public:
            static bool ReadFirstPass(WidgetBase& widget, LoaderContext& context);
            static bool ReadSecondPass(WidgetBase& widget, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<WidgetBase*>: public GenericAssetBuilderBase<WidgetBase*> {
        public:
            static WidgetBase* Create(LoaderContext& context);
            static void Dispose(WidgetBase* widget);
        };
    }
}

#endif  // CANDERA_WIDGETBASE_BUILDER_H
