//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "WidgetBaseAssetBuilder.h"
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/BehaviorCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/MetaInfoAssetBuilder.h>
#include <CanderaWidget/WidgetBase/WidgetBase.h>
#include <CanderaBehavior/BehaviorBase/Behavior.h>

namespace Candera {
    using namespace Diagnostics;
    using namespace MemoryManagement;
    using namespace MetaInfo;

    namespace Internal {
        FEATSTD_LOG_SET_REALM(LogRealm::CanderaAssetLoader);

        bool AssetReaderBase<WidgetBase>::ReadFirstPass(WidgetBase& widget, LoaderContext& context)
        {
            context.id = AssetIdFunctions::GetAssetId(CFFReader::GetCanderaObjectCanderaId(context.handle));
            if (!context.id.IsValid()) {
                FEATSTD_LOG_DEBUG("GetAssetId is not valid");
            }
            widget.SetName(AssetProviderFunctions::GetName(context.provider, context.repositoryId, CFFReader::GetCanderaObjectCanderaName(context.handle)));
            Candera::Internal::AssetId result = AssetIdFunctions::GetAssetId(CFFReader::GetCanderaObjectCanderaId(context.handle));
            if (!result.IsValid()) {
                FEATSTD_LOG_DEBUG("GetAssetId is not valid");
            }
            widget.SetId(AssetIdFunctions::GetNodeId(result));

            const Char* widgetIdentifier = CFFReader::GetWidgetThisWidget(context.handle);
            if (widgetIdentifier == 0) {
                return false;
            }

            if (context.handle.IsPersistent() == false)
            {
                SizeType widgetIdentifierLength = StringPlatform::Length(widgetIdentifier);
                Char* widgetLongName = ASSETLOADER_TRANSIENT_NEW_ARRAY(Char, widgetIdentifierLength + 1);
                if (widgetLongName == 0) {
                    return false;
                }
                StringPlatform::Copy(widgetLongName, widgetIdentifier);
                widgetLongName[widgetIdentifierLength] = '\0';
                widget.SetStringId(widgetLongName, StringIdentifier::Disposer::Dispose);
            }
            else
            {
                widget.SetStringId(widgetIdentifier, 0);
            }

            return true;
        }

        bool AssetReaderBase<WidgetBase>::ReadSecondPass(WidgetBase& widget, LoaderContext& context)
        {
            WidgetSetMetaInfo* widgetSet2DMetaInfo = GetWidgetSet();
            if (widgetSet2DMetaInfo == 0) {
                FEATSTD_LOG_ERROR("Null WidgetSetMetaInfo.");
                return false;
            }

            Behavior* behavior = Dynamic_Cast<Behavior*>(&widget);
            if (behavior != 0) {
                Candera::Internal::AssetId nodeAssetId = AssetIdFunctions::GetAssetId(CFFReader::GetBehaviorNode(context.handle));
                if (nodeAssetId.IsValid()) {
#ifdef CANDERA_3D_ENABLED
                    if ((nodeAssetId.m_libraryType == SceneLib) || (nodeAssetId.m_libraryType == CompositeLib)) {
                        behavior->SetNode(AbstractNodePointer(context.provider->GetNodeByAssetId(nodeAssetId)));
                    }
#endif
#ifdef CANDERA_2D_ENABLED
                    if ((nodeAssetId.m_libraryType == Scene2DLib) || (nodeAssetId.m_libraryType == Composite2DLib)) {
                        behavior->SetNode(AbstractNodePointer(context.provider->GetNode2DByAssetId(nodeAssetId)));
                    }
#endif
                }
            }

            const Char* widgetType = AssetProviderFunctions::GetName(context.provider, context.repositoryId, CFFReader::GetDynamicItemCanderaTypeName(context.handle));
            bool result = true;
            WidgetMetaInfo* widgetMetaInfo = widgetSet2DMetaInfo->LookupItem(widgetType);
            if (widgetMetaInfo == 0) {
                FEATSTD_LOG_WARN("Null WidgetMetaInfo for %s widget type.", widgetType);
            }
            else {
                MetaInfoAssetBuilder<WidgetBase, WidgetPropertyMetaInfo, WidgetMetaInfo> metaInfoReader(widget, *widgetMetaInfo);
                LoaderContext metaInfoContext = context;
                metaInfoContext.reloadList = 0;
                result = metaInfoReader.Read(metaInfoContext);
            }

            //Shouldn't the widgets be initialized outside AssetLoader?
            widget.Init(context.provider);

            return result;
        }

        WidgetBase* AssetBuilderBase<WidgetBase*>::Create(LoaderContext& context)
        {
            WidgetSetMetaInfo* widgetSet2DMetaInfo = GetWidgetSet();
            if (widgetSet2DMetaInfo == 0) {
                FEATSTD_LOG_ERROR("Null WidgetSetMetaInfo.");
                return 0;
            }

            const Char* widgetType = AssetProviderFunctions::GetName(context.provider, context.repositoryId, CFFReader::GetDynamicItemCanderaTypeName(context.handle));
            WidgetMetaInfo* widgetMetaInfo = widgetSet2DMetaInfo->LookupItem(widgetType);

            if (widgetMetaInfo == 0) {
                FEATSTD_LOG_WARN("Null WidgetMetaInfo for %s widget type.", widgetType);
                return 0;
            }

            return widgetMetaInfo->Create();
        }

        void AssetBuilderBase<WidgetBase*>::Dispose(WidgetBase* widget)
        {
            if (widget != 0) {
                widget->Finalize();
                widget->Dispose();
            }
        }
    }
}
