//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_STYLEASSETBUILDER_H)
#define CANDERA_STYLEASSETBUILDER_H

#include <Candera/TextEngine/Style.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {

    namespace Internal {

        AssetLoaderTypeInfo(Candera::TextRendering::SharedStyle, CffLoaderType, CanderaObject);

        template<>
        class AssetReaderBase<Candera::TextRendering::SharedStyle>: public GenericAssetReaderBase<Candera::TextRendering::SharedStyle> {
        public:
            static bool ReadFirstPass(Candera::TextRendering::SharedStyle& style, LoaderContext& context);
            static bool ReadSecondPass(Candera::TextRendering::SharedStyle& style, LoaderContext& context);

        private:
            static Candera::TextRendering::Font ReadFont(const AssetDataHandle& fontHandle, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<Candera::TextRendering::SharedStyle> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<Candera::TextRendering::SharedStyle> > {
        public:
            static MemoryManagement::SharedPointer<Candera::TextRendering::SharedStyle> Create(LoaderContext& context);
        };
    }
}

#endif  // CANDERA_STYLEASSETBUILDER_H
