//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_STATEMACHINEASSETBUILDER_H)
#define CANDERA_STATEMACHINEASSETBUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {

    namespace Internal {
        class StateMachineBehaviorData;

        AssetLoaderTypeInfo(StateMachineBehaviorData, CffLoaderType, void);

        template<>
        class AssetReaderBase<StateMachineBehaviorData>: public GenericAssetReaderBase<StateMachineBehaviorData>{
        public:
            static bool ReadFirstPass(StateMachineBehaviorData& stateMachine, LoaderContext& context);
            static bool ReadSecondPass(StateMachineBehaviorData& stateMachine, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<StateMachineBehaviorData*>: public GenericAssetBuilderBase<StateMachineBehaviorData*>{
        public:
            static Candera::Internal::StateMachineBehaviorData* Create(LoaderContext& context);
            static void Dispose(StateMachineBehaviorData* stateMachine);
        };
    }
}

#endif  // CANDERA_STATEMACHINEASSETBUILDER_H
