//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "StackLayouterAssetBuilder.h"
#include <Candera/EngineBase/Layout/StackLayouter.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/StackLayoutCffReader.h>

namespace Candera {

    using namespace Diagnostics;

    namespace Internal {

        bool AssetReaderBase<StackLayouter>::ReadFirstPass(StackLayouter& layouter, LoaderContext& context)
        {
            layouter.SetArrangement(static_cast<StackLayouter::Arrangement>(CFFReader::GetStackLayoutArrangement(context.handle)));

            return true;
        }

        StackLayouter* AssetBuilderBase<StackLayouter*>::Create(LoaderContext& /*context*/)
        {
            return StackLayouter::Create();
        }
    }
}
