//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ScriptAssetBuilder.h"

#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/ScriptCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetDecompression.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultResourceProvider.h>

namespace Candera { namespace Internal {

    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);

    using namespace Candera::MemoryManagement;

    ScriptPtr ScriptBuilder::Create(LoaderContext& context)
    {
        UInt16 regionIndex = static_cast<UInt16>(CFFReader::GetScriptScriptBytesRegion(context.handle));
        UInt32 regionLength = static_cast<UInt32>(CFFReader::GetScriptScriptBytesLength(context.handle));

        Candera::Internal::AssetId result = AssetIdFunctions::GetAssetId(CFFReader::GetCanderaObjectCanderaId(context.handle));
        if (!result.IsValid()) {
            FEATSTD_LOG_DEBUG("GetAssetId is not valid");
        }
        Id id = AssetIdFunctions::GetLibraryId(result);

        ResourceDataHandle dataHandle = DefaultResourceProvider::GetResourceProviderInstance().CreateRegionDataHandle(ScriptLib, id, regionIndex, regionLength);
        ResourceObject<const Char> data(dataHandle);

        const Char* scriptData = data.GetData();
        if (scriptData == 0) {
                FEATSTD_LOG_WARN("Scrpt failed to initalize.");
            return ScriptPtr(0);
        }

        bool isOwner = false;
        if (!data.IsPersistent()) {
            Char* dataCopy = FEATSTD_NEW_ARRAY(Char, static_cast<SizeType>(dataHandle.m_size + 1));
            if (dataCopy == 0) {
                    FEATSTD_LOG_WARN("Scrpt failed to initalize.");
                return ScriptPtr(0);
            }

            StringPlatform::CopyPartial(dataCopy, scriptData, dataHandle.m_size);
            scriptData = dataCopy;
            dataCopy[dataHandle.m_size] = '\0';
            isOwner = true;
        }

        return Scripting::Script::Create(scriptData, isOwner);
    }

}}
